package com.artfess.dataShare.scheduler.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobLogManager;
import com.artfess.dataShare.scheduler.model.BizSchedulerJobLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.scheduler.model.BizSchedulerJob;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobManager;
import org.springframework.web.multipart.MultipartFile;

/**
 * 定时任务作业  ---  配置表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */


@RestController
@RequestMapping("/biz/scheduler/schedulerJob/v1/")
@Api(tags = "定时任务作业--定时任务作业配置信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizSchedulerJobController extends BaseController<BizSchedulerJobManager, BizSchedulerJob> {

    @Autowired
    BizSchedulerJobLogManager jobLogManager;

    @PostMapping(value="/sliceQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询定时任务作业配置信息")
    public PageList<BizSchedulerJob> sliceQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizSchedulerJob> queryFilter) {
        return baseService.sliceQuery(queryFilter);
    }

    @PostMapping("/insertSchedulerJob")
    @ApiOperation("添加定时任务作业配置信息")
    public CommonResult<String> insertSchedulerJob(@RequestParam (name="jobJson") String jobJson,
                                                   @RequestParam(name="files",required=false) MultipartFile[] files) throws Exception{
        if(StringUtil.isEmpty(jobJson)){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "新增定时任务作业配置信息失败!");
        }
        BizSchedulerJob schedulerJob = JsonUtil.toBean(jobJson, BizSchedulerJob.class);
        boolean result = baseService.insertSchedulerJob(schedulerJob,files);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "新增定时任务作业配置信息失败!");
        }
        return new CommonResult<>();
    }

    @PostMapping("/updateSchedulerJob")
    @ApiOperation("修改定时任务作业配置信息")
    public CommonResult<String> updateSchedulerJob(@RequestParam (name="jobJson") String jobJson,
                                                   @RequestParam(name="files",required=false) MultipartFile[] files) throws Exception{
        if(StringUtil.isEmpty(jobJson)){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "修改定时任务作业配置信息失败!");
        }
        BizSchedulerJob schedulerJob = JsonUtil.toBean(jobJson, BizSchedulerJob.class);
        boolean result = baseService.updateSchedulerJob(schedulerJob,files);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "修改定时任务作业配置信息失败!");
        }
        return new CommonResult<>();
    }

    @DeleteMapping ("/{id}")
    @ApiOperation("删除定时任务作业配置信息")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        try {
            boolean result = false;
            result = baseService.deleteSchedulerJobById(id);
            if(!result) {
                return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
            }
            return new CommonResult<>("删除成功！");
        } catch (Exception e) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,  e.getMessage());
        }
    }

    @PostMapping ("/getSchedulerJobById")
    @ApiOperation("根据ID查询定时任务作业配置信息")
    public BizSchedulerJob getSchedulerJobById(@ApiParam(name="id", value="实体id") @RequestParam String id) {
        BizSchedulerJob schedulerJob = baseService.getSchedulerJobById(id);
        return schedulerJob;
    }

    @PostMapping(value = "/startUpJob")
    @ApiOperation(value = "启动定时任务", httpMethod = "POST", notes = "启动定时任务")
    public CommonResult<String> startUpJob(@ApiParam(name = "id", value = "任务作业id") @RequestParam String id) throws Exception {
        boolean result = baseService.startUpJob(id);
        if(result == true){
            return new CommonResult<>("启动任务成功！");
        }else{
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "启动任务失败！");
        }
    }

    @PostMapping(value = "/stopJob")
    @ApiOperation(value = "停止定时任务", httpMethod = "POST", notes = "停止定时任务")
    public CommonResult<String> stopJob(@ApiParam(name = "id", value = "任务作业id") @RequestParam String id) throws Exception {
        boolean result = baseService.stopJob(id);
        if(result == true){
            return new CommonResult<>("停止任务成功！");
        }else{
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "停止任务失败！");
        }
    }

    @PostMapping(value = "/delJob")
    @ApiOperation(value = "删除定时任务", httpMethod = "POST", notes = "删除定时任务")
    public CommonResult<String> delJob(@ApiParam(name = "id", value = "任务作业id", required = true) @RequestParam String id) throws Exception {
        boolean result = baseService.delJob(id);
        if(result == true){
            return new CommonResult<>("删除任务成功！");
        }else{
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除任务失败！");
        }
    }

    @PostMapping(value = "/executeJob")
    @ApiOperation(value = "执行一次作业任务", httpMethod = "POST", notes = "执行一次作业任务")
    public CommonResult<String> executeJob(@ApiParam(name = "id", value = "任务作业id", required = true) @RequestParam String id) throws Exception {
        boolean result = baseService.executeJob(id);
        if(result == true){
            return new CommonResult<>("执行作业任务成功！");
        }else{
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "执行作业任务失败！");
        }
    }


    @RequestMapping(value = "/validClass", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "验证类", httpMethod = "GET", notes = "验证类")
    public CommonResult validClass(@ApiParam(name = "className", value = "类名", required = true) @RequestParam String className)  {
        boolean rtn = baseService.validClass(className);
        if (rtn) {
            return new CommonResult(true, "验证类成功!", null);
        } else {
            return new CommonResult(false, "验证类失败!", null);
        }
    }
}
