package com.artfess.dataShare.role.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 角色数据目录授权表（角色关联人员的目录分类）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-25
 */
@ApiModel(value="BizRoleCatalogs对象", description="角色数据目录授权表（角色关联人员的目录分类）")
@TableName("BIZ_ROLE_CATALOGS")
public class BizRoleCatalogs extends BaseModel<BizRoleCatalogs> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "角色ID（外键参考）")
    @TableField("ROLE_ID_")
    private String roleId;

    @ApiModelProperty(value = "数据明细层目录ID（外键参考）")
    @TableField("DW_CATALOGS_ID_")
    private String dwCatalogsId;

    @ApiModelProperty(value = "数据分层（DWD、APP）")
    @TableField("DATA_TYPE_")
    private String dataType;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getDwCatalogsId() {
        return dwCatalogsId;
    }

    public void setDwCatalogsId(String dwCatalogsId) {
        this.dwCatalogsId = dwCatalogsId;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizRoleCatalogs{" +
            "id=" + id +
            ", roleId=" + roleId +
            ", dwCatalogsId=" + dwCatalogsId +
            ", dataType=" + dataType +
        "}";
    }
}
