package com.artfess.dataShare.dataCollect.model;

import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.AutoOrgFillModel;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据汇聚方信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
@ApiModel(value="BizClusterInfo对象", description="数据汇聚方信息")
public class BizClusterInfo extends AutoOrgFillModel<BizClusterInfo> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "单位类型（1：外部单位，2：内部单位）")
    @TableField("COMPANY_TYPE_")
    private Integer companyType;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "系统表定义前缀命名")
    @TableField("SYS_TABLE_CODE_")
    private String sysTableCode;

    @ApiModelProperty(value = "联系人")
    @TableField("LINK_USER_")
    private String linkUser;

    @ApiModelProperty(value = "联系电话")
    @TableField("LINK_PHONE_")
    private String linkPhone;

    @ApiModelProperty(value = "'数据提供描述'")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "'是否开启数据库提供方式（0：否，1：是）'")
    @TableField("IS_DATABASE_")
    private String isDatabase;

    @ApiModelProperty(value = "'是否开启API提供方式（0：否，1：是）'")
    @TableField("IS_API_")
    private String isApi;

    @ApiModelProperty(value = "'是否开启离线文件提供方式（0：否，1：是）'")
    @TableField("IS_FILE_")
    private String isFile;

    @ApiModelProperty(value = "'是否开启消息中间件提供方式（0：否，1：是）'")
    @TableField("IS_MQ_")
    private String isMq;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDele = "0";

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getCompanyType() {
        return companyType;
    }

    public void setCompanyType(Integer companyType) {
        this.companyType = companyType;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getLinkUser() {
        return linkUser;
    }

    public void setLinkUser(String linkUser) {
        this.linkUser = linkUser;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIsDatabase() {
        return isDatabase;
    }

    public void setIsDatabase(String isDatabase) {
        this.isDatabase = isDatabase;
    }

    public String getIsApi() {
        return isApi;
    }

    public void setIsApi(String isApi) {
        this.isApi = isApi;
    }

    public String getIsFile() {
        return isFile;
    }

    public void setIsFile(String isFile) {
        this.isFile = isFile;
    }

    public String getIsMq() {
        return isMq;
    }

    public void setIsMq(String isMq) {
        this.isMq = isMq;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getSysTableCode() {
        return sysTableCode;
    }

    public void setSysTableCode(String sysTableCode) {
        this.sysTableCode = sysTableCode;
    }

    @Override
    public String toString() {
        return "BizClusterInfo{" +
            "id=" + id +
            ", companyName=" + companyName +
            ", companyType=" + companyType +
            ", sysName=" + sysName +
            ", sysCode=" + sysCode +
            ", linkUser=" + linkUser +
            ", linkPhone=" + linkPhone +
            ", sysTableCode=" + sysTableCode +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
