package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterInfoDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.vo.BizClusterInfoVo;
import com.artfess.dataShare.util.AKSKGenerator;
import com.artfess.dataShare.util.MySQLUtils;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 数据汇聚方信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
@Service
public class BizClusterInfoManagerImpl extends BaseManagerImpl<BizClusterInfoDao, BizClusterInfo> implements BizClusterInfoManager {

    @Resource
    SysDataSourceManager sysDataSourceManager;

    @Resource
    BizClusterInfoModeManager infoModeManager;


    @Override
    @Transactional(rollbackFor = Exception.class )
    public CommonResult<String> saveClusterInfo(BizClusterInfoVo vo) throws Exception {
        if(StringUtil.isEmpty(vo.getCompanyName())){
            throw new RequiredException("添加数据汇聚方信息失败，数据汇聚方信息名称必填！");
        }
        BizClusterInfo info = BizClusterInfoVo.parse(vo);
        BizClusterInfoMode infoMode = BizClusterInfoVo.parseMode(vo);
      /*  //数据库实例名称（统一实例名interchange_library）
        if(StringUtils.isBlank(infoMode.getDatabaseName())){

            //如果前端没传就默认
            infoMode.setDatabaseName("interchange_library");
        }
        //infoMode.setDatabaseName("interchange_library");*/
        if(StringUtil.isNotEmpty(info.getId())) {
            BizClusterInfo temp = queryByName(vo.getCompanyName());
            if (null != temp) {
                if (!temp.getId().equals(vo.getId())) {
                    throw new RequiredException("数据汇聚方名称已经存在，不能重复添加！");
                }
            }
            BizClusterInfo temp1 = queryBySysCode(vo.getSysCode());
            if (null != temp1) {
                if (!temp1.getId().equals(vo.getId())) {
                    throw new RequiredException("系统编码已经存在，不能重复添加！");
                }
            }
            this.update(info);
            this.infoModeManager.update(infoMode);
            if(info.getIsDatabase().equals("1") ){
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
                MySQLUtils.updateDateUser(template,infoMode.getDatabaseUser(),infoMode.getDatabasePwd());
            }

        }else{
            //添加是创建账号
            BizClusterInfo temp = queryByName(vo.getCompanyName());
            if (null != temp) {
                throw new RequiredException("数据汇聚方名称已经存在，不能重复添加！");
            }
            BizClusterInfo temp1 = queryBySysCode(vo.getSysCode());
            if (null != temp1) {
                throw new RequiredException("系统编码已经存在，不能重复添加！");
            }

            //查询交换库数据源
            //List<BizDatasourcesRelation> datasourceList = dataSourceRelationManager.queryBizDataSourceByType(1);
            //BizDatasourcesRelation dataSourceRelation = datasourceList.get(0);
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
            SysDataSource dataSource=sysDataSourceManager.getByAlias(infoMode.getDatabaseAlias());
            String dataBaseName=template.queryForObject("SELECT DATABASE()",String.class);
            String id=UniqueIdUtil.getSuid();
            info.setId(id);
            if(StringUtil.isEmpty(info.getIsDatabase())){
                info.setIsDatabase("0");
            }
            if(StringUtil.isEmpty(info.getIsFile())){
                info.setIsFile("0");
            }
            if(StringUtil.isEmpty(info.getIsApi())){
                info.setIsApi("0");
            }
            if(StringUtil.isEmpty(info.getIsMq())){
                info.setIsMq("0");
            }
            this.create(info);
            infoMode.setId(id);
            if(info.getIsDatabase().equals("1") ){
                infoMode.setSourceId(dataSource.getId());
                infoMode.setDatabaseName(dataBaseName);
                infoMode.setDatabaseAlias(infoMode.getDatabaseAlias());
            }
            if(info.getIsApi().equals("1") ){
                infoMode.setApiAk(AKSKGenerator.generateAccessKey());
                infoMode.setApiSk(AKSKGenerator.generateSecretKey());
            }
            this.infoModeManager.create(infoMode);
            if(info.getIsDatabase().equals("1") ){
                String user=infoMode.getDatabaseUser();
                String dbName= infoMode.getDatabaseName();//interchange_library
                String pwd= infoMode.getDatabasePwd();
                String grant= "all";//授全部的权限
                //创建账号
                MySQLUtils.createDataUser(template,user,pwd);
                //账号授权
                MySQLUtils.createGrant(template,grant,dbName,user);
            }

        }
        return new CommonResult<String>(true, "操作数据汇聚方信息成功！", "");
    }

    @Override
    public BizClusterInfoVo queryClusterInfo(String id) throws Exception{
        BizClusterInfoMode mode = this.infoModeManager.getById(id);
        BizClusterInfo info = this.getById(id);
        BizClusterInfoVo vo = new BizClusterInfoVo();
        BeanUtils.copyNotNullProperties(vo,info);
        BeanUtils.copyNotNullProperties(vo,mode);
        return vo;
    }

    @Override
    public BizClusterInfo queryByName(String name) throws Exception {
            QueryWrapper<BizClusterInfo> queryWrapper=new QueryWrapper();
            queryWrapper.eq("COMPANY_NAME_",name);
            queryWrapper.last(" limit 1");
            return this.baseMapper.selectOne(queryWrapper);
    }

    public BizClusterInfo queryBySysCode(String sysCode) throws Exception {
        QueryWrapper<BizClusterInfo> queryWrapper=new QueryWrapper();
        queryWrapper.eq("SYS_CODE_",sysCode);
        queryWrapper.last(" limit 1");
        return this.baseMapper.selectOne(queryWrapper);
    }

    public boolean checkUserExists(String dbAlias,String user) throws Exception{
        //mysql写法、、以后根据情况扩展
        String sql="SELECT COUNT(*) FROM mysql.user WHERE user = ?";
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
        Integer count=jdbcTemplate.queryForObject(sql,new Object[]{user},Integer.class);
        if(count>0){
            return false;
        }
        return true;
    }

    //逻辑修改 下列代码取消
    /*@Override
     @Transactional(rollbackFor = Exception.class )
    public CommonResult<String> saveClusterInfo(BizClusterInfoVo vo)
            throws Exception {
        if(StringUtil.isEmpty(vo.getCompanyName())){
            throw new RequiredException("添加数据汇聚方信息失败，数据汇聚方信息名称必填！");
        }
        BizClusterInfo info = BizClusterInfoVo.parse(vo);
        info.setUpdateTime(LocalDateTime.now());
        if(StringUtil.isNotEmpty(info.getId())){
            BizClusterInfo temp=queryByName(vo.getCompanyName());
            if(null!=temp){
                if(!temp.getId().equals(vo.getId())){
                    throw new RequiredException("数据汇聚方名称已经存在，不能重复添加！");
                }
            }
            update(info);
            saveDataBase(info);
            //修改的是不操作数据源和修改数据库
            //SysDataSource sysDataSource=initSysDataSource(info);
            //sysDataSource.setId(info.getId());
            //sysDataSourceManager.update(sysDataSource);
        }else {
            if(null!=queryByName(vo.getCompanyName())){
                throw new RequiredException("数据汇聚方名称已经存在，不能重复添加！");
            }
            //info.setDatabaseAlias(PinyinUtil.getPinyin(vo.getCompanyName()));
            info.setId(UniqueIdUtil.getSuid());
            create(info);
            //选择了库表提供方式才创建表
            if("1".equals(info.getIsDatabase())){

                //BizDatasourcesRelation dataSourceRelation=dataSourceRelationManager.queryBizDataSourceByType(1);
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(vo.getDbAlias());

                //创建数据库
                MySQLUtils.initChangeSource(template, info.getDatabaseUser(), info.getDatabasePwd(), info.getDatabaseName());

                //创建系统数据集
                saveDataBase(info);

                JdbcTemplate clusterTemplate = DataSourceUtil.getJdbcTempByDsAlias(info.getDatabaseAlias());
                //创建数据采集临时表（用于采集任务）、数据变化临时表（用于数据变化统计）
                MySQLUtils.createCollectTable(clusterTemplate);
            }
        }
        return new CommonResult<String>(true, "添加数据汇聚方信息成功！", "");
    }
    @Transactional(rollbackFor = Exception.class )
    public CommonResult<String> saveDataBase(BizClusterInfo info){
        try {
            //添加数据源
            SysDataSource sysDataSource = initSysDataSource(info);
            boolean isConnection = sysDataSourceManager.checkConnection(sysDataSource);
            boolean isAliasExist = sysDataSourceManager.isAliasExist(sysDataSource.getAlias());
            if (isAliasExist && StringUtil.isEmpty(sysDataSource.getId())) {
                return new CommonResult<String>(false, "别名已存在");
            }
            if (!isConnection) {
                return new CommonResult<String>(false, "连接数据库失败，操作失败");
            }
            //String url="jdbc:mysql://140.210.194.126:23166/datashare?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&zeroDateTimeBehavior=convertToNull";
            if (StringUtil.isEmpty(sysDataSource.getId())) {
                sysDataSource.setId(info.getId());
                sysDataSource.setEnabled(true);
                sysDataSourceManager.create(sysDataSource);
            }else{
                sysDataSourceManager.update(sysDataSource);
            }

        }catch (Exception e){
            e.printStackTrace();
            //MySQLUtils.removeBaseUser(template, info.getDatabaseName(), info.getDatabaseUser());
            throw new RequiredException("添加数据汇聚方信息失败，数据汇聚方信息名称必填！"+e.getMessage());
        }
        return new CommonResult<String>(false, "连接数据库失败，操作失败");
    }

    @Transactional(rollbackFor = Exception.class )
    public SysDataSource initSysDataSource(BizClusterInfo info){
        SysDataSource sysDataSource=new SysDataSource();
        sysDataSource.setDbType(info.getDatabaseType());
        sysDataSource.setName(info.getDatabaseName());
        sysDataSource.setAlias(info.getDatabaseAlias());
        sysDataSource.setEnabled(true);
        sysDataSource.setClassPath("com.alibaba.druid.pool.DruidDataSource");
        sysDataSource.setSettingJson("[{\"name\":\"username\",\"comment\":\"username\",\"type\":\"java.lang.String\",\"baseAttr\":\"1\",\"default\":\"root\",\"value\":\""+info.getDatabaseUser()+"\"}," +
                "{\"name\":\"password\",\"comment\":\"password\",\"type\":\"java.lang.String\",\"baseAttr\":\"1\",\"default\":\"root\",\"value\":\""+info.getDatabasePwd()+"\"}," +
                "{\"isAdd\":true,\"name\":\"url\",\"comment\":\"url\",\"type\":\"java.lang.String\",\"baseAttr\":\"1\",\"default\":\"\",\"value\":\""+info.getDatabaseUrl()+"\"}," +
                "{\"isAdd\":true,\"name\":\"driverClass\",\"comment\":\"driverClass\",\"type\":\"java.lang.String\",\"baseAttr\":\"1\",\"default\":\"\",\"value\":\"com.mysql.cj.jdbc.Driver\"}," +
                "{\"name\":\"initialSize\",\"comment\":\"initialSize\",\"type\":\"int\",\"baseAttr\":\"1\",\"default\":\"10\",\"value\":\"10\"}," +
                "{\"name\":\"maxActive\",\"comment\":\"maxActive\",\"type\":\"int\",\"baseAttr\":\"1\",\"default\":\"100\",\"value\":\"100\"}," +
                "{\"name\":\"minIdle\",\"comment\":\"minIdle\",\"type\":\"int\",\"baseAttr\":\"1\",\"default\":\"10\",\"value\":\"10\"}," +
                "{\"name\":\"maxWait\",\"comment\":\"maxWait\",\"type\":\"long\",\"baseAttr\":\"1\",\"default\":\"60000\",\"value\":\"60000\"}," +
                "{\"name\":\"validationQuery\",\"comment\":\"validationQuery\",\"type\":\"java.lang.String\",\"baseAttr\":\"1\",\"default\":\"select 1 from dual\",\"value\":\"select 1 from dual\"}," +
                "{\"name\":\"testOnBorrow\",\"comment\":\"testOnBorrow\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"false\",\"value\":\"false\"},{" +
                "\"name\":\"testOnReturn\",\"comment\":\"testOnReturn\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"false\",\"value\":\"false\"},{" +
                "\"name\":\"testWhileIdle\",\"comment\":\"testWhileIdle\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"true\",\"value\":\"true\"}," +
                "{\"name\":\"poolPreparedStatements\",\"comment\":\"poolPreparedStatements\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"true\",\"value\":\"true\"}," +
                "{\"name\":\"maxPoolPreparedStatementPerConnectionSize\",\"comment\":\"maxPoolPreparedStatementPerConnectionSize\",\"type\":\"int\",\"baseAttr\":\"1\",\"default\":\"20\",\"value\":\"20\"}," +
                "{\"name\":\"filters\",\"comment\":\"filters\",\"type\":\"java.util.List\",\"baseAttr\":\"1\",\"default\":\"config,stat\",\"value\":\"config,stat\"}," +
                "{\"name\":\"timeBetweenEvictionRunsMillis\",\"comment\":\"timeBetweenEvictionRunsMillis\",\"type\":\"long\",\"baseAttr\":\"1\",\"default\":\"60000\",\"value\":\"60000\"}," +
                "{\"name\":\"minEvictableIdleTimeMillis\",\"comment\":\"minEvictableIdleTimeMillis\",\"type\":\"long\",\"baseAttr\":\"1\",\"default\":\"300000\",\"value\":\"300000\"}," +
                "{\"name\":\"removeAbandoned\",\"comment\":\"removeAbandoned\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"true\",\"value\":\"true\"}," +
                "{\"name\":\"removeAbandonedTimeoutMillis\",\"comment\":\"removeAbandonedTimeoutMillis\",\"type\":\"long\",\"baseAttr\":\"1\",\"default\":\"60000\",\"value\":\"60000\"}," +
                "{\"name\":\"logAbandoned\",\"comment\":\"logAbandoned\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"true\",\"value\":\"true\"}," +
                "{\"isAdd\":true,\"name\":\"breakAfterAcquireFailure\",\"comment\":\"breakAfterAcquireFailure\",\"type\":\"boolean\",\"baseAttr\":\"1\",\"default\":\"true\",\"value\":\"true\"}]");
        return sysDataSource;
    }

    public BizClusterInfo queryByName(String name) throws Exception{
        QueryWrapper<BizClusterInfo> queryWrapper=new QueryWrapper();
        queryWrapper.eq("COMPANY_NAME_",name);
        queryWrapper.last(" limit 1");
        return this.baseMapper.selectOne(queryWrapper);
    }*/
}
