package com.artfess.dataShare.dataCollect.dao;

import com.artfess.dataShare.dataCollect.model.BizDatasourcesRelation;
import com.artfess.dataShare.dataCollect.vo.BizDataSourceVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 数据源关联表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
public interface BizDatasourcesRelationDao extends BaseMapper<BizDatasourcesRelation> {

    /**
     * 数据源关联列表
     * @return
     */
    @Select("select t.*,t1.DATASOURCES_TYPE_ from portal_sys_datasource t right join biz_datasources_relation t1 on t.alias_=t1.ALIAS_ where t1.datasources_type_=#{datasourcesType}")
    List<BizDataSourceVo> queryList(Integer datasourcesType);

    @Select("select t.*,t1.DATASOURCES_TYPE_ from portal_sys_datasource t right join biz_datasources_relation t1 on t.alias_=t1.ALIAS_ where t1.id=#{id}")
    BizDataSourceVo queryBizDatasourcesRelationById(String id);
}
