package com.artfess.dataShare.dataCollect.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.vo.BizClusterInfoVo;
import com.artfess.dataShare.dataCollect.vo.checkUserExistsVo;
import com.artfess.poi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.checkerframework.checker.units.qual.A;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoManager;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据汇聚方信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
@RestController
@RequestMapping("/biz/dataCollect/clusterInfo/v1/")
@Api(tags = "数据汇聚-数据汇聚方信息管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizClusterInfoController extends BaseController<BizClusterInfoManager, BizClusterInfo> {

    @Resource
    BizClusterInfoManager clusterInfoService;

    @Resource
    BizClusterInfoModeManager clusterInfoModeManager;

    /**
     * 添加数据汇聚方信息
     * @param role
     * @return
     * @throws Exception
     *
     */
    @RequestMapping(value="saveClusterInfo",method= RequestMethod.POST, produces = {"application/json; charset=utf-8" })
    @ApiOperation(value = "保存数据汇聚方信息", httpMethod = "POST", notes = "保存数据汇聚方信息")
    public CommonResult<String> saveClusterInfo(@ApiParam(name="role",value="数据汇聚方信息参数对象", required = true) @RequestBody BizClusterInfoVo role) throws Exception{
        if(role.getIsDatabase().equals("1") && StringUtil.isEmpty(role.getDatabaseAlias())){
            throw new ApplicationException("请选择交换数据源");
        }
        boolean exists = true;
        if (role.getIsDatabase().equals("1") && StringUtil.isEmpty(role.getId())){
            exists = clusterInfoService.checkUserExists(role.getDatabaseAlias(),role.getDatabaseUser());
        }
        if(!exists){
            return new CommonResult<String>(false, "创建用户【"+role.getDatabaseUser()+"】已经存在不可以创建！", "");
        }
        CommonResult<String> rtn = clusterInfoService.saveClusterInfo(role);
        return rtn;
    }

    @RequestMapping(value="queryClusterInfo/{id}",method= RequestMethod.POST, produces = {"application/json; charset=utf-8" })
    @ApiOperation(value = "根据ID查询数据汇聚方信息", httpMethod = "POST", notes = "根据ID查询数据汇聚方信息")
    public BizClusterInfoVo queryClusterInfo(@ApiParam(name="id",value="汇聚方ID", required = true) @PathVariable String id) throws Exception{
        BizClusterInfoVo vo = clusterInfoService.queryClusterInfo(id);
        return vo;
    }

    @RequestMapping(value="checkUserExists",method= RequestMethod.POST, produces = {"application/json; charset=utf-8" })
    @ApiOperation(value = "验证创建的用户是否存在", httpMethod = "POST", notes = "验证创建的用户是否存在")
    /*public CommonResult<String> checkUserExists(@ApiParam(name="dbAlias",value="数据源", required = true)  @RequestParam String dbAlias,
                        @ApiParam(name="user",value="用户", required = true)  @RequestParam String user) throws Exception{*/
    public CommonResult<String> checkUserExists(@RequestBody checkUserExistsVo vo) throws Exception{
        boolean exists = clusterInfoService.checkUserExists(vo.getDbAlias(),vo.getUser());
        if(!exists){
            return new CommonResult<String>(false, "用户已经存在不可以创建！", "");
        }
        return new CommonResult<String>(true, "验证成功，用户可以创建！", "");
    }

    //下载链接文件
    @RequestMapping(value="downClusterInfo/{id}",method= RequestMethod.GET, produces = {"application/json; charset=utf-8" })
    @ApiOperation(value = "下载链接文件", httpMethod = "GET", notes = "下载链接文件")
    public void saveClusterInfo(HttpServletResponse response, @ApiParam(name="id",value="数据汇聚方信息参数对象", required = true) @PathVariable String id) throws Exception{
        BizClusterInfoMode info=clusterInfoModeManager.getById(id);
        List<Map<String,Object>> listMap = new ArrayList<>();
        listMap.add(JsonUtil.toMap(JsonUtil.toJson(info)));

        Map<String,String> exportMap = new LinkedHashMap<>();
        exportMap.put("databaseName","分配数据库实例的名称");
        exportMap.put("databaseUser","分配数据库用户");
        exportMap.put("databasePwd","分配数据库密码");
        exportMap.put("databaseUrl","分配数据库地址");
        exportMap.put("ak","分配数据库地址");
        List<BizClusterInfoMode> list=new ArrayList<>();
        list.add(info);
        HSSFWorkbook exportFile = ExcelUtil.exportExcel("数据库链接文件", 22, exportMap, listMap);
        ExcelUtil.downloadExcel(exportFile,"数据库链接文件",response);
        //exportFile.write(new File("D:\\123.xlsx"));
    }


}
