package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.dataShare.algorithm.model.BizAlgorithmRelation;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmRelationDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmRelationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 算法推理管理----算法指标关系说明表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-15
 */
@Service
public class BizAlgorithmRelationManagerImpl extends BaseManagerImpl<BizAlgorithmRelationDao, BizAlgorithmRelation> implements BizAlgorithmRelationManager {

    @Override
    public List<BizAlgorithmRelation> queryByVersionId(String versionId) {
        QueryWrapper<BizAlgorithmRelation> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TASK_VERSON_ID",versionId);
        return this.list(queryWrapper);
    }

    @Override
    public List<BizAlgorithmRelation> queryByCurrentIndexId(String currentIndexId) {
        QueryWrapper<BizAlgorithmRelation> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("CURRENT_INDEX_ID_",currentIndexId);
        return this.list(queryWrapper);
    }
}
