package com.artfess.dataShare.algorithm.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmTaskinfoManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmTaskinfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 算法推理管理----算法推理信息管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@RestController
@RequestMapping("/biz/algorithm/taskInfo/v1/")
@Api(tags = "算法推理管理----算法推理信息管理 ")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAlgorithmTaskinfoController extends BaseController<BizAlgorithmTaskinfoManager, BizAlgorithmTaskinfo> {

    //发布的时候选择一个版本
    @PostMapping("/deploy")
    @ApiOperation("发布算法推理信息管理")
    public CommonResult<String> deploy(@ApiParam(name="id", value="id") @RequestParam String id
            ,@ApiParam(name="versionId", value="版本Id") @RequestParam String versionId
            ,@ApiParam(name="routineName", value="DS任务工作流名称") @RequestParam String routineName) throws Exception {
        baseService.deploy(id,versionId,routineName);
        return new CommonResult<String>(true, "发布算法推理信息管理");
    }

    //添加的时候就生成一个版本 重写保存接口
    @PostMapping("/updateDeployedStatus")
    @ApiOperation("修改算法推理状态信息")
    public CommonResult<String> updateDeployedStatus(@ApiParam(name="id", value="id") @RequestParam String id
            ,@ApiParam(name="deployedStatus", value="算法推理状态") @RequestParam String deployedStatus) throws Exception {
        baseService.updateDeployedStatus(id,deployedStatus);
        return new CommonResult<String>(true, "修改算法推理状态信息成功");
    }

    //添加的时候就生成一个版本 重写保存接口
    @PostMapping("/saveTaskInfo")
    @ApiOperation("保存算法推理信息")
    public CommonResult<String> saveTaskInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) BizAlgorithmTaskinfo task) throws Exception {
        baseService.saveTaskInfo(task);
        return new CommonResult<String>(true, "保存算法推理信息成功");
    }

    //另存为要复制4个关系表的任务版本 （版本表、编排表、基础配置、公式说明、关系说明）
    /*@PostMapping("/saveAsTaskInfo")
    @ApiOperation("保存新版本算法推理信息")
    public CommonResult<String> saveAsTaskInfo(@ApiParam(name="id", value="id") @RequestParam String id
            ,@ApiParam(name="versionCode", value="版本编码") @RequestParam String versionCode
            ,@ApiParam(name="versionName", value="版本名称") @RequestParam String versionName) throws Exception {
        baseService.saveAsTaskInfo(id,versionName,versionCode);
        return new CommonResult<String>(true, "保存新版本算法推理信息成功");
    }*/
}
