package com.artfess.dataShare.util;

import com.artfess.base.model.Column;

public class FieldUtil {

    public static String getColumnType(String columnType) {
        if ("字符串".equalsIgnoreCase(columnType)) {
            return "varchar";
        } else if ("小数".equalsIgnoreCase(columnType)) {
            return "decimal";
        } else if ("日期".equalsIgnoreCase(columnType)) {
            return "date";
        }else if ("数值".equals(columnType)||"数字".equals(columnType)) {
            return "number";
        } else if ("文本".equalsIgnoreCase(columnType)) {
            return "text";
        } else {
            return "";
        }
    }

    public static String getColumnType(String columnType, int charLen, int intLen, int decimalLen) {
        if (Column.COLUMN_TYPE_VARCHAR.equals(columnType)) {
            return "VARCHAR(" + charLen + ')';
        } else if (Column.COLUMN_TYPE_NUMBER.equals(columnType)) {
            return "DECIMAL(" + (intLen + decimalLen) + "," + decimalLen + ")";
        } else if (Column.COLUMN_TYPE_DATE.equals(columnType)) {
            return "DATETIME";
        } else if (Column.COLUMN_TYPE_INT.equals(columnType)) {
            return "BIGINT(" + intLen + ")";
        } else if (Column.COLUMN_TYPE_CLOB.equals(columnType)) {
            return "TEXT";
        } else if (Column.COLUMN_TYPE_TEXT.equals(columnType)) {
            return "TEXT";
        } else if (Column.COLUMN_TYPE_STRING.equals(columnType)) {
            return "STRING";
        } else {
            return "";
        }
    }

}
