package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 调度任务 - 资源项的调度配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */
@ApiModel(value="BizSchedulerJobTable对象", description="调度任务 - 资源项的调度配置表")
@TableName("BIZ_SCHEDULER_JOB_TABLE")
public class BizSchedulerJobTable extends BaseModel<BizSchedulerJobTable> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据资源表_ID（数据表）")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "定时作业_ID")
    @TableField("JOB_ID_")
    private String jobId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerJobTable{" +
            "id=" + id +
            ", tableId=" + tableId +
            ", jobId=" + jobId +
        "}";
    }
}
