package com.artfess.dataShare.factory;

import com.artfess.base.constants.SQLConst;

public class QueryDataTableFactory {

    /**
     * 通过数据库类型获得表查询数据
     *
     * @param param 查询参数
     * @return
     * @throws Exception
     */
    public static QueryResultData getTableData(QueryParam param) throws Exception {
        String dbType=param.getDbType();
        if (dbType.equalsIgnoreCase(SQLConst.DB_ORACLE)) {
            return new MySQLQueryData().queryTableData(param);
        } else if (dbType.equalsIgnoreCase(SQLConst.DB_MYSQL)) {
            return new MySQLQueryData().queryTableData(param);
        } else if (dbType.equalsIgnoreCase(SQLConst.DB_SQLSERVER) || dbType.equalsIgnoreCase(SQLConst.DB_SQLSERVER2005)) {
            return new MySQLQueryData().queryTableData(param);
        } else if (dbType.equalsIgnoreCase(SQLConst.DB_DB2)) {
            return new MySQLQueryData().queryTableData(param);
        } else if (dbType.equalsIgnoreCase(SQLConst.DB_H2)) {
            return new MySQLQueryData().queryTableData(param);
        } else if (dbType.equalsIgnoreCase(SQLConst.DB_DM)) {
            return new MySQLQueryData().queryTableData(param);
        } else if (dbType.equalsIgnoreCase(SQLConst.DB_POSTGRESQL)) {
            return new MySQLQueryData().queryTableData(param);
        }else {
            throw new Exception("数据库类型错误");
        }
    }
}
