package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据共享管理--离线文件共享下载日志
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-29
 */
@ApiModel(value="BizShareFileLog对象", description="数据共享管理--离线文件共享下载日志")
@TableName("BIZ_SHARE_FILE_LOG")
@Data
public class BizShareFileLog extends BaseModel<BizShareFileLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "需求调用方ID")
    @TableField("MEMBER_ID_")
    private String memberId;

    @ApiModelProperty(value = "需求调用方_编码")
    @TableField("MEMBER_CODE_")
    private String memberCode;

    @ApiModelProperty(value = "需求调用方_名称")
    @TableField("MEMBER_NAME_")
    private String memberName;

    @ApiModelProperty(value = "需求调用方_系统名称")
    @TableField("APP_NAME_")
    private String appName;

    @ApiModelProperty(value = "需求调用访问的资源表_ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "调用访问的资源_编码")
    @TableField("RESOURCE_CODE_")
    private String resourceCode;

    @ApiModelProperty(value = "调用访问的资源_名称")
    @TableField("RESOURCE_NAME_")
    private String resourceName;

    @ApiModelProperty(value = "调用下载的文件_ID")
    @TableField("FILE_ID_")
    private String fileId;

    @ApiModelProperty(value = "调用下载的文件_名称")
    @TableField("FILE_NAME_")
    private String fileName;

    @ApiModelProperty(value = "调用下载的文件_地址")
    @TableField("FILE_PATH_")
    private String filePath;

    @ApiModelProperty(value = "客户端访问的_IP地址")
    @TableField("REQUEST_IP_")
    private String requestIp;

    @ApiModelProperty(value = "客户端请求访问时间")
    @TableField("REQUEST_TIME_")
    private LocalDateTime requestTime;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_time_", fill= FieldFill.INSERT, select=true)
    private LocalDateTime createTime;
}
