package com.artfess.dataShare.dataShare.manager;

import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.dataShare.model.BizShareTableField;
import com.artfess.base.manager.BaseManager;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

/**
 * 数据共享管理--共享资源表字段信息（字段） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
public interface BizShareTableFieldManager extends BaseManager<BizShareTableField> {

    /**
     * 批量添加实体的接口
     * @param table
     * @return
     */
    boolean saveInfoBatch(BizShareTable table) throws SQLException;

    /**
     * 获取表字段
     * @param tableId
     * @return
     */
    List<BizShareTableField> queryFieldByTable(String tableId);

    /**
     * 导入字段
     * @param file
     * @param tableId
     */
    void importFile(MultipartFile file, String tableId) throws Exception;

    /**
     * 修改发布后的表字段信息-同时要修改实体表
     * @param field
     */
    void saveOrUpdateFields(List<BizShareTableField> field) throws Exception;
}
