package com.artfess.dataShare.dataShare.manager;

import com.artfess.dataShare.dataApi.model.BizServiceCatalogs;
import com.artfess.dataShare.dataShare.model.BizShareCatalogs;
import com.artfess.base.manager.BaseManager;

/**
 * 数据资产-共享资源目录 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 伍彬
 * @since 2024-12-03
 */
public interface BizShareCatalogsManager extends BaseManager<BizShareCatalogs> {
    /**
     * 修改目录树
     * @param shareCatalogs
     * @return
     */
    public String upTree(BizShareCatalogs shareCatalogs);

    /**
     * 删除目录树
     * @param id
     * @return
     */
    public boolean deleteById(String id);

    /**
     * 移动树
     * @param id
     * @param parentId
     * @return
     */
    boolean removeTree(String id, String parentId);

    String saveTree(BizShareCatalogs shareCatalogs);
}
