package com.artfess.dataShare.dataResource.ods.model;

import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据每次采集量明细记录表（每次采集明细）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-18
 */
@TableName("BIZ_SCHEDULER_COLLECT_TIMES")
@ApiModel(value="BizSchedulerCollectTimes对象", description="数据每次采集量明细记录表（每次采集明细）")
public class BizSchedulerCollectTimes extends BaseModel<BizSchedulerCollectTimes> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "数据表名")
    @TableField("TABLE_NAME_")
    private String tableName;

    @ApiModelProperty(value = "数据统计时间")
    @TableField("COUNT_DATE_")
    private LocalDateTime countDate;

    @ApiModelProperty(value = "数据采集完成状态（0：失败 1：成功）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "ods表当前数据总量")
    @TableField("TOTAL_NUM_")
    private Integer totalNum;

    @ApiModelProperty(value = "统计周期新增量")
    @TableField("ADD_NUM_")
    private Integer addNum;

    @ApiModelProperty(value = "统计周期修改量")
    @TableField("UPDATE_NUM_")
    private Integer updateNum;

    @ApiModelProperty(value = "统计周期删除量")
    @TableField("DEL_NUM_")
    private Integer delNum;

    @ApiModelProperty(value = "数据量日统计状态（0：未统计 1：已统计）")
    @TableField("DAY_STAT_STATUS_")
    private String dayStatStatus;

    @ApiModelProperty(value = "创建日期")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public LocalDateTime getCountDate() {
        return countDate;
    }

    public void setCountDate(LocalDateTime countDate) {
        this.countDate = countDate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getAddNum() {
        return addNum;
    }

    public void setAddNum(Integer addNum) {
        this.addNum = addNum;
    }

    public Integer getUpdateNum() {
        return updateNum;
    }

    public void setUpdateNum(Integer updateNum) {
        this.updateNum = updateNum;
    }

    public Integer getDelNum() {
        return delNum;
    }

    public void setDelNum(Integer delNum) {
        this.delNum = delNum;
    }

    public String getDayStatStatus() {
        return dayStatStatus;
    }

    public void setDayStatStatus(String dayStatStatus) {
        this.dayStatStatus = dayStatStatus;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerCollectTimes{" +
            "id=" + id +
            ", companyName=" + companyName +
            ", sysName=" + sysName +
            ", sysCode=" + sysCode +
            ", name=" + name +
            ", code=" + code +
            ", tableName=" + tableName +
            ", countDate=" + countDate +
            ", status=" + status +
            ", totalNum=" + totalNum +
            ", addNum=" + addNum +
            ", updateNum=" + updateNum +
            ", delNum=" + delNum +
            ", dayStatStatus=" + dayStatStatus +
            ", createTime=" + createTime +
            ", isDele=" + isDele +
        "}";
    }
}
