package com.artfess.dataShare.dataResource.ods.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.ods.dao.BizOdsCatalogsDao;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsCatalogsManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsCatalogs;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 数据资产--ODS资源目录
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2024-11-13
 */
@Service
public class BizOdsCatalogsManagerImpl extends BaseManagerImpl<BizOdsCatalogsDao, BizOdsCatalogs> implements BizOdsCatalogsManager {

    @Autowired
    private SysTypeManager sysTypeManager;

    @Override
    public List<BizOdsCatalogs> getTree(BizOdsCatalogs entity) {
        QueryWrapper<BizOdsCatalogs> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }
        queryWrapper.orderByAsc("sn_");
        List<BizOdsCatalogs> sysList = this.baseMapper.selectList(queryWrapper);
        List<BizOdsCatalogs> tree = BeanUtils.listToTree(sysList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public CommonResult<String> moveTree(String id, String parentId) throws Exception {
        Assert.hasText(id, "ids不能为空");
        Assert.hasText(parentId, "treeId不能为空");
        if(StringUtil.isEmpty(id)||StringUtil.isEmpty(parentId)){
            throw new RequiredException("移动节点或目标节点id不能为空！");
        }
        BizOdsCatalogs rel = this.get(id);
        if(BeanUtils.isEmpty(rel)){
            throw new RequiredException("根据移动节点id【"+id+"】未找到对应节点！");
        }
        if(parentId.equals(rel.getParentId())){
            return new CommonResult<String>(true, "节点【"+rel.getName()+"】已经是其子节点，不需要更新！", "");
        }
        BizOdsCatalogs parentRel = this.get(parentId);
        List<BizOdsCatalogs> childrens = this.getByParentId(parentRel.getId());
        if(BeanUtils.isEmpty(parentRel)){
            throw new RequiredException("根据目标节点id【"+parentId+"】未找到对应节点！");
        }else{
            rel.setFullId(parentRel.getFullId()+"/"+rel.getId());
        }
        rel.setParentId(parentId);
        this.update(rel);
        updatePortalSysType(id,parentId);
        updateChildrenRel(rel);
        return new CommonResult<String>(true, "更新目录线成功！", "");
    }

    /**
     * 递归更新子的节点th
     * @throws Exception
     */
    @Transactional(rollbackFor = Exception.class )
    public void updateChildrenRel(BizOdsCatalogs parentRel) throws Exception{
        List<BizOdsCatalogs> childrens = this.getByParentId(parentRel.getId());
        for (BizOdsCatalogs rel : childrens) {
            rel.setFullId(parentRel.getFullId()+"/"+rel.getId());
            this.update(rel);
            updatePortalSysType(rel.getId(),parentRel.getId());
            updateChildrenRel(rel);
        }
    }

    public List<BizOdsCatalogs> getByParentId(String parentId) throws Exception {
        if(StringUtil.isEmpty(parentId)){
            throw new RequiredException("父节点id“parentId”不能为空！");
        }
        QueryWrapper<BizOdsCatalogs> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("parent_id_",parentId);
        return this.list(queryWrapper);
        //return baseMapper.getByParentId(parentId);
    }



    @Transactional(rollbackFor = Exception.class )
    public void updatePortalSysType(String id,String parentId) throws Exception {
        SysType sysType=sysTypeManager.getById(id);
        sysType.setParentId(parentId);
        //SysType sysTypeTemp = sysTypeManager.getInitSysType(0,parentId);
        SysType parent=this.sysTypeManager.get(parentId);
        String path=parent.getPath();
        sysType.setPath(path +id +".");
        sysTypeManager.update(sysType);
    }
}
