package com.artfess.dataShare.dataResource.dw.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.poi.annotation.Excel;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;

/**
 * 数据DW字段信息-动态表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
@Data
@ApiModel(value="BizDWField-动态表对象", description="动态表-数据DW字段信息")
public class BizDwFieldDVo {

    @Excel(name ="*字段英文名")
    private String fieldCode;

    @Excel(name ="*字段中文名")
    private String name;

    @Excel(name ="*字段描述（字段备注释义）")
    private String desc;

    @Excel(name ="*数据类型",readConverterExp = "varchar=字符串,number=数字,date=日期")
    private String dataType;

    @Excel(name ="数据长度")
    private Integer attrLength;

    @Excel(name ="页面控件")
    private String uiComCode;

    @Excel(name ="字段值对应的类型编码")
    private String fieldValueType;

    @Excel(name ="序号")
    private Integer sn;

    @Excel(name ="备注")
    private String remark;

    public static BizDwdCatalogsTableField parse(BizDwFieldDVo roleVo){
        BizDwdCatalogsTableField vo = new BizDwdCatalogsTableField();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }


}
