package com.artfess.dataShare.dataResource.app.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsTableDao;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableFieldManager;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableManager;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableVo;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.Constants;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.EasyExcelUtil;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据应用层--APP应用层表管理 （TABLE） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
@Service
public class BizAppCatalogsTableManagerImpl extends BaseManagerImpl<BizAppCatalogsTableDao, BizAppCatalogsTable> implements BizAppCatalogsTableManager {

    @Resource
    BizAppCatalogsTableFieldManager appCatalogsTableFieldManager;

    @Transactional(rollbackFor = Exception.class )
    public void export(MultipartFile file, String catalogId) throws Exception {
        ExcelTool<BizAppTableVo> util = new ExcelTool<BizAppTableVo>(BizAppTableVo.class);
        List<BizAppTableVo> list = util.importExcel(file.getInputStream(),3,4);
        list=list.stream().filter(p-> org.apache.commons.lang3.StringUtils.isNotBlank(p.getTableNameEn())).collect(Collectors.toList());
        if(list.size()==0){
            throw new BaseException("表没有检测到需要导入的数据，注意中文名不能为空。");
        }
        //判断表名是否存在
        for(BizAppTableVo vo : list){
            if(StringUtil.isEmpty(vo.getTableNameCh())){
                continue;
            }
            if(StringUtil.isEmpty(vo.getTableNameCh())){
                throw new BaseException("表"+vo.getName()+"中文名不能为空");
            }
            if(StringUtil.isEmpty(vo.getTableNameEn())){
                throw new BaseException("表"+vo.getName()+"英文名不能为空");
            }
            if(checkTable(vo.getCode())){
                throw new BaseException("表【"+vo.getName()+"("+vo.getCode()+")】已经存在");
            }
        }
        for(BizAppTableVo vo : list){
            if(StringUtil.isEmpty(vo.getCode())){
                continue;
            }
            //System.out.println(vo.toString());

            BizAppCatalogsTable table=vo.parseTable(vo);
           /* Map<String,String> idsMap=createMouldAndTable(vo.getName(),vo.getCode(),vo.getDesc(),"LOCAL");
            mould.setId(idsMap.get("defId"));
            table.setId(idsMap.get("tableId"));*/
            table.setAppCatalogsId(catalogId);
            table.setIsCreateTable("0");
            table.setDeployed("0");
            table.setIsDele("0");
            table.setTableNameEn("app_"+table.getTableNameEn());
            this.create(table);
        }
    }

    public boolean checkTable(String tableName){
        QueryWrapper<BizAppCatalogsTable> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_NAME_EN_",tableName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    //根据表下载导入模板
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws  Exception {
        BizAppCatalogsTable dwTable = this.getById(tableId);
        List<BizAppCatalogsTableField> field=appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        if(field.size()==0){
            throw new ApplicationException("资源表未设置字段。");
        }
        //物理表
            Map<String,String> exportMap = new LinkedHashMap<>();
            for(BizAppCatalogsTableField field1 : field){
                if("2".equals(field1.getFieldType())) {
                    exportMap.put(field1.getName(), field1.getDesc());
                }
            }
            // 拼装exprotMaps
            HSSFWorkbook book = ExcelUtil.exportExcel(dwTable.getName(), 12, exportMap, new ArrayList<>(), 0);
            ExcelUtil.downloadExcel(book, dwTable.getName() + "_导入模板", response);
            //book.write(new File("D:\\1234.xlsx"));
    }

    //根据表和EXCEL导入数据到表
    /*@Override
    @Transactional(rollbackFor = Exception.class )
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizAppCatalogsTable dwTable = this.getById(tableId);
        List<BizAppCatalogsTableField> fieldLists=appCatalogsTableFieldManager.queryFieldByTableId(dwTable.getId());
        Map<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizAppCatalogsTableField field : fieldLists) {//这里同注释的会被覆盖，所以要导入导出的不要出现相同的列注释
            nameFieldMap.put(field.getDesc(), field.getFieldCode());
        }
        List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        for (Map<String, String> row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");

            List<String> fields = new ArrayList<String>();
            List<String> values = new ArrayList<String>();
            fields.add(BizAppCatalogsTableField.PK_NAME);
            values.add("'" +UniqueIdUtil.getSuid()+ "'");
            for (Map.Entry<String, String> map : row.entrySet()) {
                //excel单元格有值才去拼接sql
                if (BeanUtils.isNotEmpty(map.getValue())) {
                    String key = map.getKey();
                    String field = this.getFieldName(key, fieldLists, nameFieldMap.get(key));
                    fields.add(field);
                    String dataType = this.getDataType(key, fieldLists, nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add(map.getValue());
                    } else {
                        values.add("'" + map.getValue() + "'");
                    }
                }

            }
            //加入额外的两个字段
            //fields.add("F_form_data_rev_");
            //values.add("0");

            sql.append(dwTable.getTableNameEn());
            sql.append("(" + String.join(",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join(",", values) + ")");

            jdbcTemplate.execute(sql.toString());
        }
    }*/

    //根据表和EXCEL导入数据到表
    @Override
    @Transactional
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizAppCatalogsTable dwTable = this.getById(tableId);
        if("1".equals(dwTable.getTableClass())){
            importWExcelData(file,dwTable);
        }else if("2".equals(dwTable.getTableClass())){
            exportDExcelData(file,dwTable);
        }

    }

    //导入物理表
    @Transactional(rollbackFor = Exception.class )
    public void importWExcelData(MultipartFile file, BizAppCatalogsTable dwTable) throws Exception {
        List<BizAppCatalogsTableField> fieldLists=appCatalogsTableFieldManager.queryFieldByTableId(dwTable.getId());
        Map<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizAppCatalogsTableField field : fieldLists) {//这里同注释的会被覆盖，所以要导入导出的不要出现相同的列注释
            nameFieldMap.put(field.getDesc(), field.getFieldCode());
        }
        List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        for (Map<String, String> row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");

            List<String> fields = new ArrayList<String>();
            List<String> values = new ArrayList<String>();
            fields.add(BizAppCatalogsTableField.PK_NAME);
            values.add("'" +UniqueIdUtil.getSuid()+ "'");
            for (Map.Entry<String, String> map : row.entrySet()) {
                //excel单元格有值才去拼接sql
                if (BeanUtils.isNotEmpty(map.getValue())) {
                    String key = map.getKey();
                    String field = this.getFieldName(key, fieldLists, nameFieldMap.get(key));
                    fields.add(field);
                    String dataType = this.getDataType(key, fieldLists, nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add("'" +map.getValue()+ "'");
                    } else {
                        values.add("'" + map.getValue() + "'");
                    }
                }

            }
            //加入额外的两个字段
            //fields.add("F_form_data_rev_");
            //values.add("0");

            sql.append(dwTable.getTableNameEn());
            sql.append("(" + String.join(",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join(",", values) + ")");

            jdbcTemplate.execute(sql.toString());
        }
    }

    //导入动态表
    @Transactional(rollbackFor = Exception.class )
    public void exportDExcelData(MultipartFile file, BizAppCatalogsTable dwTable) throws Exception {
        List<Object> data= EasyExcelUtil.readMoreThan1000Row(file.getInputStream());
        List<BizAppCatalogsTableField> fields=appCatalogsTableFieldManager.queryFieldByTableId(dwTable.getId());
        fields = fields.stream().filter(p->p.getFieldType().equals("2")).collect(Collectors.toList());
        Map<String,BizAppCatalogsTableField> fieldMap=fields.stream().collect(Collectors.toMap(p->p.getFieldCode(),p->p));
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        String tableName=dwTable.getTableNameEn().replace("app_","");
        IUser user= ContextUtil.getCurrentUser();
        IGroup org=ContextUtil.getCurrentGroup();
        String uId=user.getUserId();
        String tenantId=user.getTenantId();
        String orgId=org.getGroupId();
        //动态表
        String insertDsql="insert into APP_D_"+tableName+"(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_," +
                "USER_PHONE_,DATA_ID_,DATA_JSON_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" +
                " values(?,?,?,?,?,?,?,?,?,?,?,?,now(),?)";

        String recordTable="APP_D_"+tableName+"_COLUMN";
        String insertSql="insert into "+recordTable+ "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_,USER_PHONE_,DATA_ID_," +
                "FIELD_ID_,FIELD_CODE_,FIELD_VALUE_,FIELD_UI_MODULE_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" +
                " values (?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,now(),?)";
        List<Object[]> dDataList=new ArrayList<>();
        List<Object[]> rDataList=new ArrayList<>();
        List<String> fieldList=new ArrayList<>();
        for(int i=0;i<data.size();i++){
            List<String> rows= (List<String>) data.get(i);
            if(i==0){
                String title=rows.get(0);
                //tableName=title.substring(title.indexOf("-")+1);
            }else if(i==1){
                for(String field : rows){
                    String fieldName=field.substring(field.indexOf("-")+1);
                    fieldList.add(fieldName);
                }
            }else{
                String pcId = UniqueIdUtil.getSuid();
                //计算批次
                JSONObject jsonObject = new JSONObject();
                //String userId=rows.get(0);
                String userName=rows.get(0);
                String userSex=rows.get(1);
                String userIdentityCard=rows.get(2);
                String userPhone=rows.get(3);
                for(int j=4;j< rows.size();j++){
                    String value=rows.get(j);
                    //System.out.println(fieldList.get(j));
                    jsonObject.put(fieldMap.get(fieldList.get(j)).getFieldCode(),value);
                }
                List<Object> dParam=new ArrayList<>();
                dParam.add(UniqueIdUtil.getSuid());
                dParam.add("");
                dParam.add(userName);
                dParam.add(userSex);
                dParam.add(userIdentityCard);
                dParam.add(userPhone);
                dParam.add(pcId);
                dParam.add(jsonObject.toJSONString());
                dParam.add(LocalDateTime.now());
                dParam.add(1);
                dParam.add(uId);
                dParam.add(orgId);
                dParam.add(tenantId);
                dDataList.add(dParam.toArray());
                //计算字段
                for(int j=4;j< rows.size();j++){
                    String value=rows.get(j);
                    BizAppCatalogsTableField tableField = fieldMap.get(fieldList.get(j));

                    List<Object> rParam=new ArrayList<>();
                    rParam.add(UniqueIdUtil.getSuid());
                    rParam.add("1");
                    rParam.add(userName);
                    rParam.add(userSex);
                    rParam.add(userIdentityCard);
                    rParam.add(userPhone);
                    rParam.add(pcId);
                    rParam.add(tableField.getId());
                    rParam.add(tableField.getFieldCode());
                    rParam.add(value);
                    rParam.add(tableField.getUiComCode());
                    rParam.add(LocalDateTime.now());
                    rParam.add(1);
                    rParam.add(uId);
                    rParam.add(orgId);
                    rParam.add(tenantId);
                     /*insertSql="insert into "+recordTable+ "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_,USER_PHONE_,DATA_ID_," +
                            "FIELD_ID_,FIELD_CODE_,FIELD_VALUE_,FIELD_UI_MODULE_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" +
                            "values ('"+UniqueIdUtil.getSuid()+"','1','"+userName+"','"+userSex+"','"+userIdentityCard+"','"+userPhone+"','"+pcId+"'," +
                        "'"+tableField.getId()+"','"+tableField.getFieldCode()+"','"+value+"','"+tableField.getUiComCode()+"','"+LocalDateTime.now()+"','"+1+"','"+uId+"','"+orgId+"',now(),'"+tenantId+"')";
                    jdbcTemplate.execute(insertSql);*/
                    rDataList.add(rParam.toArray());
                }
            }
        }
        jdbcTemplate.batchUpdate(insertDsql,dDataList);
        jdbcTemplate.batchUpdate(insertSql,rDataList);
    }

    private String getFieldName(String key, List<BizAppCatalogsTableField> columnList, String fieldName) {
        for (BizAppCatalogsTableField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getFieldCode();
            }
        }
        return "";
    }

    private String getDataType(String key, List<BizAppCatalogsTableField> columnList, String fieldName) {
        for (BizAppCatalogsTableField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getDataType();
            }
        }
        return "";
    }

    //发布的时候建表
    @Transactional(rollbackFor = Exception.class )
    public void Deploy(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizAppCatalogsTable table= this.getById(tableId);
        String tableName=table.getTableNameEn();
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        List<BizAppCatalogsTableField> fieldList = appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        if(fieldList.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        if("1".equals(table.getDeployed())){
            for(BizAppCatalogsTableField field : fieldList){
                if(!"1".equals(field.getIsCreate())){
                    field.setIsCreate("1");
                    //创建字段
                    Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
                    Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
                    String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
                    field.setDecimalLen(decimalLen);
                    field.setFlSql(fieldSq);
                    template.execute(fieldSq);
                }
            }
            //修改字段创建状态
            appCatalogsTableFieldManager.updateBatchById(fieldList);
        }else {
            //List<BizAppCatalogsTableField> fieldList = appCatalogsTableFieldManager.queryFieldByTableId(tableId);
            for(BizAppCatalogsTableField field : fieldList){
                field.setIsCreate("1");
                Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
                Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
                String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
                field.setDecimalLen(decimalLen);
                field.setFlSql(fieldSq);
            }
            //修改字段创建状态
            appCatalogsTableFieldManager.updateBatchById(fieldList);

            //获取数据源
            table.setIsCreateTable("1");
            //table.setTableName(table.getTableName());
            table.setCode(table.getTableNameEn());
            table.setDeployed("1");
            table.setDeployedTime(LocalDateTime.now());
            //this.update(table);

            //3、在ods库里面创建表和字段  doris
            String createSql = DorisUtils.createAppTable(template, table.getTableNameEn(),tableDesc, fieldList);
            table.setCreateTableSql(createSql);
            this.update(table);
        }
    }

    public BizAppTableDetailVo queryTableVo(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizAppTableDetailVo vo = new BizAppTableDetailVo();
        BizAppCatalogsTable table=this.getById(tableId);
        if(null==table){
            throw new BaseException("未查询到表");
        }
        vo.setTable(table);
        vo.setFieldList(this.appCatalogsTableFieldManager.queryFieldByTableId(tableId));
        return vo;
    }


    public QueryResultData queryTableData (QueryParamVo queryParamVo) throws Exception{
        //Assert.hasText(queryParamVo.getTableId(),"表ID不能为空");
        if(StringUtil.isEmpty(queryParamVo.getTableId()) && StringUtil.isEmpty(queryParamVo.getTableName())){
            throw new ApplicationException("表ID或者表名不能为空");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties(queryParam,queryParamVo);
        BizAppCatalogsTable table= null;
        if(StringUtil.isNotEmpty(queryParam.getTableId())){
            table = this.getById(queryParam.getTableId());
        }else {
            QueryWrapper<BizAppCatalogsTable> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("TABLE_NAME_EN_", queryParamVo.getTableName());
            table = this.baseMapper.selectOne(queryWrapper);
        }

        if(table == null){
            return null;
        }


        queryParam.setTableName(table.getTableNameEn());
        List<BizAppCatalogsTableField> fieldList = appCatalogsTableFieldManager.queryFieldByTableId(table.getId());
        //只提取业务字段
        Map<String,String> field = fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toMap(BizAppCatalogsTableField::getFieldCode, p->p.getName()));
        field.put("id_","主键");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);

        /*BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dataSourcesRelation.getAlias());*/
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType("mysql");
        return QueryDataTableFactory.getTableData(queryParam);
    }

    @Transactional(rollbackFor = Exception.class )
    public void removeTable(String tableId) throws Exception {
        BizAppCatalogsTable table=this.getById(tableId);
        boolean exists = checkPhysicsTableExists(table.getTableNameEn());
        if (exists){
            //如果表已经发布，删除实体表
            if("1".equals(table.getDeployed())){
                String dropSql="drop table "+table.getTableNameEn();
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
                template.execute(dropSql);
            }
        }

        QueryWrapper<BizAppCatalogsTableField> queryWrapper=new QueryWrapper();
        queryWrapper.eq("table_id_",tableId);
        this.removeById(tableId);
        appCatalogsTableFieldManager.remove(queryWrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public void deployHaveTable(String tableId) throws Exception {
        BizAppCatalogsTable table = this.get(tableId);
        if("1".equals(table.getDeployed())){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        this.update(table);
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public void deployDotHaveTable(String tableId,String tableSql,String detailTableSql) throws Exception {
        BizAppCatalogsTable table = this.get(tableId);
        if("1".equals(table.getDeployed())){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        List<BizAppCatalogsTableField> tableFields = appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        if(tableFields.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        table.setCreateTableSql(tableSql);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        if ("2".equals(table.getTableClass())){
            table.setCreateTableDSql(detailTableSql);
            template.execute(table.getCreateTableDSql());
        }
        template.execute(table.getCreateTableSql());
        this.update(table);
    }

    @Override
    public boolean checkTableExists(String tableNameEn) throws Exception{
        tableNameEn="app_"+tableNameEn;
        //查询表库是否存在
        if(checkTable(tableNameEn)){
            return true;
        }
        //查询数据库是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public boolean saveInfo(BizAppCatalogsTable table) {
        table.setIsCreateTable("0");
        table.setDeployed("0");
        table.setIsDele("0");
        return save(table);
    }

    @Override
    public boolean checkPhysicsTableExists(String tableNameEn) throws Exception {
        //查询数据库是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public Map<String, String> queryAppTable(String tableId) {
        BizAppCatalogsTable table = get(tableId);
        Map<String,String> result = new HashMap<>();
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        String appMainSql = DorisUtils.queryAppMainSql(table.getTableNameEn(),tableDesc);
        String appDetailSql = DorisUtils.queryAppDetailSql(table.getTableNameEn(),tableDesc);
        result.put("appMainSql",appMainSql);
        result.put("appDetailSql",appDetailSql);
        return result;
    }

    @Transactional
    public QueryResultData queryDTTableData(QueryParamVo queryParamVo) throws Exception{
        //Assert.hasText(queryParamVo.getTableId(),"表ID不能为空");
        if(StringUtil.isEmpty(queryParamVo.getTableId()) && StringUtil.isEmpty(queryParamVo.getTableName())){
            throw new ApplicationException("表ID或者表名不能为空");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties(queryParam,queryParamVo);
        BizAppCatalogsTable table= null;
        if(StringUtil.isNotEmpty(queryParam.getTableId())){
            table = this.getById(queryParam.getTableId());
        }else {
            QueryWrapper<BizAppCatalogsTable> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("TABLE_NAME_EN_", queryParamVo.getTableName());
            table = this.baseMapper.selectOne(queryWrapper);
        }

        if(table == null){
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizAppCatalogsTableField> fieldList = appCatalogsTableFieldManager.queryFieldByTableId(table.getId());
        //只提取业务字段
        Map<String,String> field = fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toMap(BizAppCatalogsTableField::getFieldCode, p->p.getName()));
        field.put("id_","主键");
        if(queryParam.getPageNo()==0){
            field = fieldList.stream().collect(Collectors.toMap(BizAppCatalogsTableField::getFieldCode, p->p.getName()));
        }

        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        Integer pageNo=queryParamVo.getPageNo();
        Integer pageSize=queryParamVo.getPageSize();
        String order = queryParamVo.getOrder();
        String tableName=table.getTableNameEn();
        Map<String,String> paramMap= queryParamVo.getParam();
        tableName=tableName.replace("dw_","");
        QueryResultData resultData = new QueryResultData();

        String mainTable="APP_D_"+tableName;
        String recordTable="APP_D_"+tableName+"_COLUMN";

        String querySql="select * from "+mainTable+" where 1=1";
        String querySqlCount="select count(*) from "+recordTable+" where 1=1";
        for(String key : paramMap.keySet()){
            querySql+=" and "+key+" = '"+paramMap.get(key)+"'";
            querySqlCount+=" and "+key+" = '"+paramMap.get(key)+"'";
        }
        if(pageNo>0) {
            int total=template.queryForObject(querySqlCount, Integer.class);
            resultData.setTotal(total);
        }
        if(StringUtil.isNotEmpty(order)){
            querySql+=" order by "+order;
        }else{
            querySql+=" order by create_time_";
        }
        if(pageNo>1) {
            querySql += " limit " + ((pageNo - 1) * pageSize) + "," + pageSize;
        }
        resultData.setData(template.queryForList(querySql));
        resultData.setField(field);

        return resultData;
    }

    public Map<String,Object> queryTableDetailData(String tableId,String pcId) throws Exception{
        BizAppCatalogsTable table= this.getById(tableId);
        String tableName=table.getTableNameEn().replace("app_","");;
        List<BizAppCatalogsTableField> fieldList = appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        String querySql="select * from DWD_"+tableName+"_TABLE_RECORD where DATA_ID_= ? ";
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);
        List<Map<String, Object>> data = template.queryForList(querySql,new Object[]{pcId});
        Map<String,Object> result=new HashMap<>();
        result.put("data",data);
        result.put("field",fieldList);
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = baseMapper.updateCatalog(ids,catalogId);
        return count > 0 ? true : false;
    }
}
