package com.artfess.dataShare.dataResource.app.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableFieldManager;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据应用层--APP层数据表字段信息（字段） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
@RestController
@RequestMapping("/biz/app/catalogs/table/field/v1/")
@Api(tags = "数据应用层表--APP层数据表字段信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAppCatalogsTableFieldController extends BaseController<BizAppCatalogsTableFieldManager, BizAppCatalogsTableField> {
    @Autowired
    BizAppCatalogsTableFieldManager fieldManager;

    @PostMapping("/importFile")
    @ApiOperation(value = "导入数据字段信息", httpMethod = "POST", notes = "导入数据字段信息")
    public CommonResult<String> export(@RequestParam(value = "file", required = true) MultipartFile file, String tableId) throws Exception {
        this.fieldManager.export(file,tableId);
        return new CommonResult<String>(true, "导入数据DW字段信息成功");
    }

    @PostMapping("/saveTableField")
    @ApiOperation(value = "批量维护数据表和聚字段信息", httpMethod = "POST", notes = "批量维护数据表和聚字段信息")
    public CommonResult<String> saveTableField(@RequestBody BizAppTableDetailVo vo) throws Exception {
        this.fieldManager.saveTableField(vo);
        return new CommonResult<String>(true, "批量维护数据汇聚字段信息");
    }

    @PostMapping("/saveOrUpdates")
    @ApiOperation(value = "批量维护数据字段信息-单独保存字段，全度需要在每个字段里面加上tableId", httpMethod = "POST", notes = "导入数据字段信息")
    public CommonResult<String> saveTableField(@RequestBody List<BizAppCatalogsTableField> field) throws Exception {
        this.fieldManager.saveOrUpdates(field);
        return new CommonResult<String>(true, "批量维护数据汇聚字段信息");
    }

    @PostMapping("/saveOrUpdateFields")
    @ApiOperation(value = "修改发布后的表字段信息-同时要修改实体表", httpMethod = "POST", notes = "修改发布后的表字段信息-同时要修改实体表")
    public CommonResult<String> saveOrUpdateFields(@RequestBody List<BizAppCatalogsTableField> field) throws Exception {
        this.fieldManager.saveOrUpdateFields(field);
        return new CommonResult<String>(true, "修改成功");
    }
}
