package com.artfess.dataShare.dataCollect.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据汇聚字段信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-10
 */
public interface BizClusterTableFieldManager extends BaseManager<BizClusterTableField> {

    /**
     * 根据表导入表字段
     * @param file
     * @param tableId
     * @throws Exception
     */
    void export(MultipartFile file, String tableId) throws Exception;

    /**
     * 根据实体表Id查询字敦
     * @param tableId
     * @return
     */
    List<BizClusterTableField> queryFieldByTableId(String tableId);

    /**
     * 批量维护数据汇聚字段信息
     * @param vo
     */
    void saveTableField(TableDetailVo vo);

    /**
     * 修改发布后的表字段信息-同时要修改实体表
     * @param field
     */
    void saveOrUpdateFields(List<BizClusterTableField> field) throws Exception;
}
