package com.artfess.dataShare.dataCollect.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataCollect.vo.BizClusterInfoVo;

/**
 * 数据汇聚方信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
public interface BizClusterInfoManager extends BaseManager<BizClusterInfo> {

    /**
     * 添加数据汇聚方信息
     *
     * @param vo
     * @return
     * @throws Exception
     */
    CommonResult<String> saveClusterInfo(BizClusterInfoVo vo) throws Exception;

    /**
     *  根据ID查询数据汇聚方信息
     * @param id
     * @return
     * @throws Exception
     */
    BizClusterInfoVo queryClusterInfo(String id) throws Exception;

    /**
     *  根据汇聚方名称查询
     * @param name
     * @return
     * @throws Exception
     */
    BizClusterInfo queryByName(String name) throws Exception;


    /**
     * 验证创建的用户是否存在
     *
     * @return
     * @throws Exception
     */
    boolean checkUserExists( String dbAlias,String user) throws Exception;
}
