package com.artfess.dataShare.config;


import com.artfess.dataShare.dataShare.interceptor.DownloadFileInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

    @Bean
    public DownloadFileInterceptor downloadFileInterceptor(){
        return new DownloadFileInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(downloadFileInterceptor())
                .addPathPatterns("/biz/dataShare/shareFiles/v1/downloadFile");
    }
}
