package com.artfess.dataShare.algorithm.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 算法推理管理-----特征指标管理表 （结果指标、问题指标、属性指标）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@ApiModel(value="BizAlgorithmCatalogsIndex对象", description="算法推理管理-----特征指标管理表 （结果指标、问题指标、属性指标）")
public class BizAlgorithmCatalogsIndex extends AutoOrgFillModel<BizAlgorithmCatalogsIndex> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "指标分类（1：结果指标 2：问题指标 3：属性指标）")
    @TableField("LEVEL_")
    private String level;

/*    @ApiModelProperty(value = "指标类型（1：外在指标 2：内在指标）")
    @TableField("TYPE_")
    private String type;*/

    @ApiModelProperty(value = "指标编码（唯一值）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "指标名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "指标描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "字段关联状态（0：未关联字段 1：已关联字段）")
    @TableField("FIELD_RELATION_STATUS_")
    private String fieldRelationStatus;

    @ApiModelProperty(value = "指标启用状态（0：禁用 1：启用）")
    @TableField("ENABLE_STATUS_")
    private String enableStatus;

    @ApiModelProperty(value = "指标组件类型_标识符（text,select,combox,radio,textarea,date,figure,file）")
    @TableField("UI_COM_CODE")
    private String uiComCode;

    @ApiModelProperty(value = "字段值类别（1:普通字段 2:枚举字典 3:多维字典项）")
    @TableField("FIELD_VALUE_TYPE")
    private Integer fieldValueType;

    @ApiModelProperty(value = "枚举和多维_CODE（参考枚举和多维定义的CODE值）")
    @TableField("DIMENSION_ID")
    private String dimensionId;

    @ApiModelProperty(value = "枚举和多维字典JSON串值（预处理写入）")
    @TableField("DIMENSION_JSON")
    private String dimensionJson;

    @ApiModelProperty(value = "实体表归属数据库实例（1：ODS贴源库 2：DWD明细库 3：APP应用库）")
    @TableField("TABLE_CLASS")
    private String tableClass;

    @ApiModelProperty(value = "实体表中文名称")
    @TableField("TABLE_NAME_CH_")
    private String tableNameCh;

/*    @ApiModelProperty(value = "实体表英文名称")
    @TableField("TABLE_NAME_EN_")
    private String tableNameEn;*/

    @ApiModelProperty(value = "实体表_数据库表名(唯一)DWD_X_表英文名")
    @TableField("TABLE_CODE_")
    private String tableCode;

    @ApiModelProperty(value = "字段英文名（格式：F_字段编码）")
    @TableField("FIELD_CLOUMN_")
    private String fieldCloumn;

    @ApiModelProperty(value = "字段名称")
    @TableField("FIELD_NAME_")
    private String fieldName;

/*    @ApiModelProperty(value = "字段编码")
    @TableField("FIELD_CODE_")
    private String fieldCode;*/

/*    @ApiModelProperty(value = "字段描述")
    @TableField("FIELD_DESC_")
    private String fieldDesc;*/

    @ApiModelProperty(value = "字段类型。string=字符串；number=数值；datetime=日期（长日期，通过显示格式来限制）")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "字段类型显示格式（yyyy-MM-dd，yyyy-MM-dd HH:mm:ss）")
    @TableField("FORMAT_")
    private String format;

    @ApiModelProperty(value = "字段取值的计量单位名称，无计量单位的字段取空字符串。")
    @TableField("UNIT")
    private String unit;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldRelationStatus() {
        return fieldRelationStatus;
    }

    public void setFieldRelationStatus(String fieldRelationStatus) {
        this.fieldRelationStatus = fieldRelationStatus;
    }

    public String getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(String enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getUiComCode() {
        return uiComCode;
    }

    public void setUiComCode(String uiComCode) {
        this.uiComCode = uiComCode;
    }

    public Integer getFieldValueType() {
        return fieldValueType;
    }

    public void setFieldValueType(Integer fieldValueType) {
        this.fieldValueType = fieldValueType;
    }

    public String getDimensionId() {
        return dimensionId;
    }

    public void setDimensionId(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    public String getDimensionJson() {
        return dimensionJson;
    }

    public void setDimensionJson(String dimensionJson) {
        this.dimensionJson = dimensionJson;
    }

    public String getTableClass() {
        return tableClass;
    }

    public void setTableClass(String tableClass) {
        this.tableClass = tableClass;
    }

    public String getTableNameCh() {
        return tableNameCh;
    }

    public void setTableNameCh(String tableNameCh) {
        this.tableNameCh = tableNameCh;
    }

    public String getTableCode() {
        return tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public String getFieldCloumn() {
        return fieldCloumn;
    }

    public void setFieldCloumn(String fieldCloumn) {
        this.fieldCloumn = fieldCloumn;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    //保存的时间要加这四个字段  tableId：表id, sheetTreeId：树id，sheetPage:页，sheetPageSize：页数
    @ApiModelProperty(value = "表id")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "树id")
    @TableField("SHEET_TREE_ID_")
    private String sheetTreeId;

    @ApiModelProperty(value = "页")
    @TableField("SHEET_PAGE_")
    private String sheetPage;

    @ApiModelProperty(value = "页数")
    @TableField("SHEET_PAGE_SIZE_")
    private String sheetPageSize;

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getSheetTreeId() {
        return sheetTreeId;
    }

    public void setSheetTreeId(String sheetTreeId) {
        this.sheetTreeId = sheetTreeId;
    }

    public String getSheetPage() {
        return sheetPage;
    }

    public void setSheetPage(String sheetPage) {
        this.sheetPage = sheetPage;
    }

    public String getSheetPageSize() {
        return sheetPageSize;
    }

    public void setSheetPageSize(String sheetPageSize) {
        this.sheetPageSize = sheetPageSize;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAlgorithmCatalogsIndex{" +
            "id=" + id +
            ", level=" + level +
            ", code=" + code +
            ", name=" + name +
            ", description=" + description +
            ", fieldRelationStatus=" + fieldRelationStatus +
            ", enableStatus=" + enableStatus +
            ", uiComCode=" + uiComCode +
            ", fieldValueType=" + fieldValueType +
            ", dimensionId=" + dimensionId +
            ", dimensionJson=" + dimensionJson +
            ", tableClass=" + tableClass +
            ", tableNameCh=" + tableNameCh +
            ", tableCode=" + tableCode +
            ", fieldCloumn=" + fieldCloumn +
            ", fieldName=" + fieldName +
            ", dataType=" + dataType +
            ", format=" + format +
            ", unit=" + unit +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
