package com.artfess.dataShare.algorithm.dao;

import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.vo.TaskReasonVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 算法推理管理----逻辑推理编排表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
public interface BizAlgorithmReasonDao extends BaseMapper<BizAlgorithmReason> {

    /**
     * 指标推理表格查询和导出说明(1)
     */
    @Select("select t.*,t1.TYPE_,t3.name_ task_name_,t4.version_code_,t4.VERSION_NAME_,t1.NAME_ reason_name,t1.index_type_,t1.content_,t1.RELATION_CONTENT_ from (\n" +
            "select t.id_,t3.LEVEL_,t3.name_\n" +
            "from biz_algorithm_catalogs_index t3\n" +
            "left join biz_algorithm_reason t on t3.id_=t.INDEX_ID_\n" +
            "where t3.id_=#{indexId}\n" +
            ") t left join biz_algorithm_reason t1 on t.id_=t1.parent_id_\n" +
            "left join BIZ_ALGORITHM_VERSION t4 on t4.id_= t1.task_verson_id\n" +
            "left join biz_algorithm_taskinfo t3 on t1.task_id_ = t3.id_ where t1.TYPE_ = #{type} order by t1.TYPE_")
    List<TaskReasonVo> queryTaskReasonList(@Param("indexId") String indexId,@Param("type")  String type);

    List<BizAlgorithmReason> queryReason(@Param("taskId") String taskId,@Param("versionId")  String versionId);
}
