package com.artfess.sysConfig.vo;

import com.artfess.base.annotation.ExcelColumn;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DataDictExcelVo {

	//序号	目录名称	最终子目录名称	最终子目录代码	多维项代码	多维项名称	维度项定义描述
	@ApiModelProperty(name = "sn", notes = "序号", required = false)
    @ExcelColumn(value = "sn", col = 0)
	protected String sn;

	@ApiModelProperty(name = "typeCode", notes = "最终子目录代码", required = true)
	@ExcelColumn(value = "typeCode", col = 3)
	protected String typeCode;

	@ApiModelProperty(name = "key", notes = "多维项代码", required = true)
    @ExcelColumn(value = "key", col = 4)
	protected String key;

	@ApiModelProperty(name = "name", notes = "多维项名称", required = true)
    @ExcelColumn(value = "name", col = 5)
	protected String name;

	public DataDictExcelVo() {
	}

	public DataDictExcelVo(String typeCode, String key, String name) {
		this.typeCode = typeCode;
		this.key = key;
		this.name = name;
	}

	public String getSn() {
		return sn;
	}

	public void setSn(String sn) {
		this.sn = sn;
	}

	public String getTypeCode() {
		return typeCode;
	}

	public void setTypeCode(String typeCode) {
		this.typeCode = typeCode;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
