/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.FileConfig;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.persistence.dao.FileConfigDao;
import com.artfess.file.persistence.manager.FileConfigManager;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class FileConfigManagerImpl
extends BaseManagerImpl<FileConfigDao, FileConfig>
implements FileConfigManager {
    @Autowired
    FileStorageManager fileStorageManager;

    @Override
    public PageList<FileConfig> queryPage(QueryFilter<FileConfig> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<FileConfig> result = ((FileConfigDao)this.baseMapper).queryPage((IPage<FileConfig>)this.convert2IPage(pageBean), (Wrapper<FileConfig>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public FileConfig getOneById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        FileConfig fileConfig = ((FileConfigDao)this.baseMapper).getOneById(id);
        return fileConfig;
    }

    @Override
    @Transactional
    public String insertFileConfig(FileConfig fileConfig) {
        Assert.notNull((Object)((Object)fileConfig), (String)"\u9644\u4ef6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean flag = this.checkSameField("", "CODE_", fileConfig.getCode());
        if (!flag) {
            throw new ApplicationException("\u7f16\u7801\u91cd\u590d\u8bf7\u4fee\u6539\uff01");
        }
        ((FileConfigDao)this.baseMapper).insert((Object)fileConfig);
        return fileConfig.getId();
    }

    @Override
    @Transactional
    public void deleteFileConfig(String ids) {
        Assert.hasText((String)ids, (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> idsList = Arrays.asList(ids.split(","));
        ((FileConfigDao)this.baseMapper).deleteBatchIds(idsList);
    }

    @Override
    public FileConfig loadFileConfig(String id) {
        Assert.hasText((String)id, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        FileConfig fileConfig = (FileConfig)((Object)((FileConfigDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return fileConfig;
    }

    @Override
    public FileStorageConfigDTO getFileConfigByCode(String code) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<FileStorageConfigDTO> list = ((FileConfigDao)this.baseMapper).getFileConfigByCode(code);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public String updateFileConfig(FileConfig fileConfig) {
        Assert.notNull((Object)((Object)fileConfig), (String)"\u9644\u4ef6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean flag = this.checkSameField(fileConfig.getId(), "CODE_", fileConfig.getCode());
        if (!flag) {
            throw new ApplicationException("\u7f16\u7801\u91cd\u590d\u8bf7\u4fee\u6539\uff01");
        }
        this.update((Model)fileConfig);
        return fileConfig.getId();
    }
}

