/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.execution.message.plugin;

import com.artfess.base.feign.ApplicationFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.jms.Notice;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.artfess.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.artfess.bpm.plugin.execution.message.context.IExternalData;
import com.artfess.bpm.plugin.execution.message.def.HtmlSetting;
import com.artfess.bpm.plugin.execution.message.def.MessagePluginDef;
import com.artfess.bpm.plugin.execution.message.def.PlainTextSetting;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessagePlugin
extends AbstractBpmExecutionPlugin {
    private Log logger = LogFactory.getLog(GroovyScriptEngine.class);
    @Resource
    BpmPluginSessionFactory sessionFactory;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    private FreeMarkerEngine FreeMarkerEngine;

    @Override
    public Void execute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef) throws Exception {
        List<BpmIdentity> notifyIdentities;
        List<IUser> receivers;
        BpmDelegateExecution delegateExecution = pluginSession.getBpmDelegateExecution();
        String nodeName = delegateExecution.getNodeName();
        Map<String, Object> vars = delegateExecution.getVariables();
        vars.put("nodeName", nodeName);
        BpmUserCalcPluginSession bpmUserCalcPluginSession = this.sessionFactory.buildBpmUserCalcPluginSession(vars);
        MessagePluginDef messageDef = (MessagePluginDef)pluginDef;
        this.handFlowVars(vars, delegateExecution);
        this.handData(messageDef, vars, delegateExecution);
        PlainTextSetting plainSetting = messageDef.getPlainTextSetting();
        HtmlSetting htmlSetting = messageDef.getHtmlSetting();
        if (plainSetting != null && StringUtil.isNotEmpty((String)plainSetting.getContent()) && BeanUtils.isNotEmpty(receivers = this.queryAndConvert(notifyIdentities = UserAssignRuleQueryHelper.queryExtract(plainSetting.getRuleList(), bpmUserCalcPluginSession), pluginSession.getOrgEngine().getUserService()))) {
            String content = plainSetting.getContent();
            content = this.parse(content, vars);
            String notifyType = plainSetting.getMsgType();
            this.send("", content, receivers, notifyType);
        }
        if (htmlSetting != null && StringUtil.isNotEmpty((String)htmlSetting.getSubject()) && StringUtil.isNotEmpty((String)htmlSetting.getContent()) && BeanUtils.isNotEmpty(receivers = this.queryAndConvert(notifyIdentities = UserAssignRuleQueryHelper.queryExtract(htmlSetting.getRuleList(), bpmUserCalcPluginSession), pluginSession.getOrgEngine().getUserService()))) {
            String subject = htmlSetting.getSubject();
            String content = htmlSetting.getContent();
            subject = this.parse(subject, vars);
            content = this.parse(content, vars);
            String notifyType = htmlSetting.getMsgType();
            this.send(subject, content, receivers, notifyType);
        }
        return null;
    }

    private void send(String subject, String content, List<IUser> receivers, String notifyType) throws Exception {
        if (StringUtil.isEmpty((String)notifyType)) {
            return;
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        String[] recieverAccounts = MessageUtil.parseAccountOfUser(receivers);
        Notice notice = new Notice();
        notice.setMessageTypes(messageTypes);
        notice.setSender(currentUser.getAccount());
        List<Object> receiver = new ArrayList();
        receiver = MessageUtil.parseJmsActor(receivers);
        notice.setReceiver(receiver);
        notice.setReceivers(recieverAccounts);
        notice.setSubject(subject);
        notice.setContent(content);
        ApplicationFeignService PortalFeignService = (ApplicationFeignService)AppUtil.getBean(ApplicationFeignService.class);
        PortalFeignService.sendNoticeToQueue(notice);
    }

    private void handData(MessagePluginDef messageDef, Map<String, Object> vars, BpmDelegateExecution execution) {
        String externalClass = messageDef.getExternalClass();
        if (StringUtil.isEmpty((String)externalClass)) {
            return;
        }
        String instId = (String)vars.get("instanceId_");
        String bpmnDefId = execution.getBpmnDefId();
        String bpmnInstId = execution.getBpmnInstId();
        String nodeId = execution.getNodeId();
        String executionId = execution.getId();
        try {
            Class<?> cls = Class.forName(externalClass);
            IExternalData data = (IExternalData)cls.newInstance();
            Map<String, Object> varMap = data.getData(bpmnDefId, bpmnInstId, instId, nodeId, executionId);
            vars.putAll(varMap);
        }
        catch (ClassNotFoundException e) {
            this.logger.debug((Object)e.getMessage());
        }
        catch (InstantiationException e) {
            this.logger.debug((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.debug((Object)e.getMessage());
        }
    }

    private String parse(String template, Object obj) throws Exception {
        return this.FreeMarkerEngine.parseByTemplate(template, obj);
    }

    private List<IUser> queryAndConvert(List<BpmIdentity> bpmIdentities, IUserService userService) {
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            IUser user = userService.getUserById(bpmIdentity.getId());
            userList.add(user);
        }
        return userList;
    }

    private void handFlowVars(Map<String, Object> vars, BpmDelegateExecution execution) {
        try {
            Map<String, ObjectNode> boMap;
            BpmProcessInstance instance;
            ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
            if (BeanUtils.isNotEmpty((Object)taskCmd) && BeanUtils.isNotEmpty((Object)(instance = (BpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
                IUser user;
                IUserService userService;
                String userId = instance.getCreateBy();
                if (BeanUtils.isNotEmpty((Object)userId) && BeanUtils.isNotEmpty((Object)(userService = (IUserService)AppUtil.getBean(IUserService.class))) && BeanUtils.isNotEmpty((Object)(user = userService.getUserById(userId)))) {
                    vars.put("startorName", user.getFullname());
                }
                vars.put("startDate", DateFormatUtil.format((LocalDateTime)instance.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                vars.put("businessKey", taskCmd.getBusinessKey());
            }
            if (BeanUtils.isEmpty(boMap = BpmContextUtil.getBoFromContext())) {
                BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(vars.get("instanceId_").toString());
                List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
                BpmContextUtil.setBoToContext(boDatas);
                boMap = BpmContextUtil.getBoFromContext();
            }
            if (BeanUtils.isNotEmpty(boMap)) {
                Collection<ObjectNode> dataObjects = boMap.values();
                for (ObjectNode boData : dataObjects) {
                    ObjectNode bodef = (ObjectNode)boData.get("boDef");
                    String boName = bodef.get("alias").asText();
                    ObjectNode dataMap = (ObjectNode)boData.get("data");
                    Iterator iterator = dataMap.fields();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        vars.put(boName + "_" + (String)entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

