package com.artfess.uc.vo;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 转岗培训设置
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-04-18
 */
@Data
@ApiModel(value="TransPositionVo对象", description="转岗培训设置")
public class TransPositionVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "转岗前岗位id")
    private String sourcePosId;

    @ApiModelProperty(value = "转岗学员id")
    private String userId;

    @ApiModelProperty(value = "转岗学员名称")
    private String userName;

    @ApiModelProperty(value = "转岗学员账号")
    private String userAccount;

    @ApiModelProperty(value = "转岗后岗位ID", hidden = true)
    private String targetPosId;
}
