package com.artfess.uc.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;

/**
 * 用户信息扩展表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-09-13
 */

@ApiModel(value="BizUserExtend对象", description="用户信息扩展表")
@TableName("biz_user_extend")
@Data
@EqualsAndHashCode(callSuper = true)
public class BizUserExtend extends BizDelModel<BizUserExtend> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "出生年月(yyyy-MM-dd)")
    @TableField("birthday_")
    private LocalDate birthday;

    @ApiModelProperty(value = "文化程度")
    @TableField("diploma_")
    private String diploma;

    @ApiModelProperty(value = "入职时间(yyyy-MM-dd)")
    @TableField("hire_date_")
    private LocalDate hireDate;

    @ApiModelProperty(value = "身份证号")
    @TableField("id_number_")
    private String idNumber;

    @ApiModelProperty(value = "职称")
    @TableField("job_title_")
    private String jobTitle;

    @ApiModelProperty(value = "工种")
    @TableField("work_type_")
    private String workType;

    @ApiModelProperty(value = "有何技能和特长相关证书")
    @TableField("skills_")
    private String skills;

    @ApiModelProperty(value = "工作经历")
    @TableField("work_experience_")
    private String workExperience;
}
