package com.artfess.portal.kh.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.kh.dao.KhSchemeDao;
import com.artfess.portal.kh.manager.KhSchemeIndicatorsManager;
import com.artfess.portal.kh.manager.KhSchemeManager;
import com.artfess.portal.kh.model.KhScheme;
import com.artfess.portal.kh.model.KhSchemeIndicators;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 考核方案信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Service
public class KhSchemeManagerImpl extends BaseManagerImpl<KhSchemeDao, KhScheme> implements KhSchemeManager {

    @Autowired
    private KhSchemeIndicatorsManager detailsManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(KhScheme t) {
        t.setStatus("0");
        boolean save = this.save(t);
        if(save) {
            processDetail(t);
            return save;
        }
        return false;
    }

    private void processDetail(KhScheme t) {
        LambdaQueryWrapper<KhSchemeIndicators> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(KhSchemeIndicators::getId, t.getId());
        detailsManager.remove(lambdaQueryWrapper);
        if(CollectionUtils.isEmpty(t.getSchemeIndicatorsList())){
            return;
        }
        t.getSchemeIndicatorsList().forEach(detail -> {
            detail.setSchemeId(t.getId());
        });
        detailsManager.saveBatch(t.getSchemeIndicatorsList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(KhScheme t) {
        boolean save = this.updateById(t);
        if(save) {
            processDetail(t);
            return save;
        }
        return false;
    }

    @Override
    public KhScheme findById(String id) {
        KhScheme KhScheme = this.get(id);
        Assert.notNull(KhScheme, "评级方案不存在");
        List<KhSchemeIndicators> list = detailsManager.findBySchemeId(id);
        KhScheme.setSchemeIndicatorsList(list);
        return KhScheme;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatus(List<String> ids, String status) {
        LambdaQueryWrapper<KhScheme> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(KhScheme::getId, ids);
        List<KhScheme> list = this.list(lambdaQueryWrapper);
        list.forEach(KhScheme -> {
            List<KhSchemeIndicators> indicators = detailsManager.findBySchemeId(KhScheme.getId());
            Assert.notEmpty(indicators, "指标信息不存在");
            KhScheme.setStatus(status);
        });
        boolean b = this.updateBatchById(list);
        return b;
    }
}
