/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.template.TemplateEngine;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.i18n.persistence.manager.I18nMessageManager;
import com.artfess.i18n.persistence.manager.I18nMessageTypeManager;
import com.artfess.i18n.persistence.model.I18nMessage;
import com.artfess.i18n.persistence.model.I18nMessageType;
import com.artfess.i18n.support.service.MessageService;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/i18n/custom/i18nMessage/v1/"})
@Api(tags={"\u56fd\u9645\u5316\u8d44\u6e90"})
@ApiGroup(group={"group_system"})
public class I18nMessageController
extends BaseController<I18nMessageManager, I18nMessage> {
    @Resource
    I18nMessageManager i18nMessageManager;
    @Resource
    MessageService messageService;
    @Resource
    I18nMessageTypeManager i18nMessageTypeManager;
    @Resource
    TemplateEngine templateEngine;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Map<String, String>> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<I18nMessage> queryFilter) throws Exception {
        return this.i18nMessageManager.getList(queryFilter);
    }

    @RequestMapping(value={"init"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521d\u59cb\u5316\u56fd\u9645\u5316\u8d44\u6e90\u5230Cache\u4e2d", httpMethod="POST", notes="\u521d\u59cb\u5316\u56fd\u9645\u5316\u8d44\u6e90\u5230Cache\u4e2d")
    public CommonResult<String> init() throws Exception {
        this.messageService.initMessage();
        return new CommonResult("\u521d\u59cb\u5316\u8d44\u6e90\u6210\u529f");
    }

    public static void main(String[] args) throws Exception {
        String userIds = "11,12,123,132";
        System.out.println(userIds.split(","));
    }

    @RequestMapping(value={"clearCache"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u7a7aCache\u4e2d\u7684\u6240\u6709\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u6e05\u7a7aCache\u4e2d\u7684\u6240\u6709\u56fd\u9645\u5316\u8d44\u6e90")
    public void clearCache() throws Exception {
        this.messageService.clearAllMessage();
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u56fd\u9645\u5316\u8d44\u6e90\u660e\u7ec6\u9875\u9762")
    public Object getJson(@ApiParam(name="id", value="i18n\u5b9a\u4e49id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new I18nMessage();
        }
        I18nMessage i18nMessage = (I18nMessage)this.i18nMessageManager.get((Serializable)((Object)id));
        return i18nMessage;
    }

    @RequestMapping(value={"getI18nMessageJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90")
    public Object getI18nMessageJson(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        HashMap map = null;
        String dbType = SQLUtil.getDbType();
        map = this.i18nMessageManager.getByMesKey(key, dbType);
        ArrayList mesTypeInfo = new ArrayList();
        List typeList = this.i18nMessageTypeManager.list();
        for (I18nMessageType type : typeList) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", type.getType());
            m.put("desc", type.getDesc());
            if (BeanUtils.isNotEmpty(map)) {
                if (BeanUtils.isNotEmpty(map.get(type.getType()))) {
                    m.put("val", map.get(type.getType()).toString());
                } else {
                    m.put("val", "");
                }
            }
            mesTypeInfo.add(m);
        }
        if (BeanUtils.isEmpty((Object)map)) {
            map = new HashMap();
        }
        map.put("mesTypeInfo", mesTypeInfo);
        return map;
    }

    @RequestMapping(value={"getByMessKey"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90")
    public Object getByMessKey(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        Map map = null;
        String dbType = SQLUtil.getDbType();
        map = this.i18nMessageManager.getByMesKey(key, dbType);
        return map;
    }

    @RequestMapping(value={"delByKey"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8d44\u6e90key\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="DELETE", notes="\u6839\u636e\u8d44\u6e90key\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90")
    public Object delByKey(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        try {
            String[] keys = StringUtil.getStringAryByStr((String)key);
            this.i18nMessageManager.delByKeys(keys);
            return new CommonResult(true, I18nUtil.getMessage((String)"\u5220\u9664\u6210\u529f", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"\u5220\u9664\u5931\u8d25", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u56fd\u9645\u5316\u8d44\u6e90\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u56fd\u9645\u5316\u8d44\u6e90\u4fe1\u606f")
    public Object save(@ApiParam(name="i18nMessage", value="i18n\u5b9a\u4e49\u7684\u5b9e\u4f53", required=true) @RequestBody I18nMessage i18nMessage, @ApiParam(name="oldKey", value="i18n\u5b9a\u4e49\u7684oldKey", required=true) @RequestParam String oldKey) throws Exception {
        try {
            this.i18nMessageManager.saveI18nMessage(i18nMessage.getKey(), i18nMessage.getMesTypeInfo(), oldKey);
            return new CommonResult(true, I18nUtil.getMessage((String)"i18nMessage.operationSuccess", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"i18nMessage.operationFail", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90\u8bb0\u5f55")
    public Object remove(@ApiParam(name="ids", value="i18n\u5b9a\u4e49ids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.i18nMessageManager.removeByIds(aryIds);
            return new CommonResult(true, I18nUtil.getMessage((String)"\u6279\u91cf\u5220\u9664\u6210\u529f", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"\u6279\u91cf\u5220\u9664\u5931\u8d25", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }

    @RequestMapping(value={"jsResource/{jsAlias}"})
    public void getJsResource(@PathVariable(value="jsAlias") String jsAlias, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Cache-Control", "max-age=300");
        response.setHeader("Pragma", "max-age=300");
        response.getWriter().print(this.getJsResource(jsAlias));
    }

    private List<String> getCodes(String temp) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern regex = Pattern.compile("\"\\$\\{(.*?)\\}\"");
        Matcher regexMatcher = regex.matcher(temp);
        while (regexMatcher.find()) {
            result.add(regexMatcher.group(1));
        }
        return result;
    }

    private String getJsResource(String resourceName) throws Exception {
        if (StringUtil.isEmpty((String)resourceName)) {
            throw new RuntimeException("\u8d44\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String templatePath = String.format("template/message/%s.ftl", resourceName);
        String jsTemplate = FileUtil.readByClassPath((String)templatePath);
        if (StringUtil.isEmpty((String)jsTemplate)) {
            throw new RuntimeException(String.format("\u8d44\u6e90\u540d\u79f0\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728:%s", templatePath));
        }
        List<String> codes = this.getCodes(jsTemplate);
        Map messages = I18nUtil.getMessages(codes, (Locale)LocaleContextHolder.getLocale());
        String jsonResource = this.templateEngine.parseByTemplate(jsTemplate, (Object)messages);
        return jsonResource;
    }

    @RequestMapping(value={"importMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eceexcel\u5bfc\u5165\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u4eceexcel\u5bfc\u5165\u56fd\u9645\u5316\u8d44\u6e90")
    public Object importMessage(@ApiParam(name="file", value="i18n\u5b9a\u4e49file", required=true) @RequestParam MultipartFile file) throws Exception {
        String resultMsg = "";
        try {
            this.i18nMessageManager.importMessage(file);
            resultMsg = "\u5bfc\u5165\u56fd\u9645\u5316\u8d44\u6e90\u6210\u529f\uff01";
            return new CommonResult(true, resultMsg, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"exportMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u5bfc\u51fa\u56fd\u9645\u5316\u8d44\u6e90")
    public void exportMessage(HttpServletResponse response) throws Exception {
        try {
            HSSFWorkbook book = this.i18nMessageManager.exportExcel();
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)"\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868", (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"getListJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eval\u83b7\u53d6\u6240\u6709\u6570\u636e", httpMethod="POST", notes="\u6839\u636eval\u83b7\u53d6\u6240\u6709\u6570\u636e")
    public Object getListJson(@ApiParam(name="val", value="i18n\u5b9a\u4e49val", required=true) @RequestParam String val) throws Exception {
        ArrayList rtn = new ArrayList();
        List datas = this.i18nMessageManager.getSearchList(val);
        for (Map m : datas) {
            HashMap data = new HashMap();
            ArrayList vals = new ArrayList();
            for (String key : m.keySet()) {
                if ("key_".equals(key.toLowerCase())) {
                    data.put("key", m.get(key));
                    continue;
                }
                vals.add(m.get(key));
            }
            data.put("vals", vals);
            rtn.add(data);
        }
        return rtn;
    }
}

