/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.constants.CategoryConstants;
import com.artfess.sysConfig.persistence.manager.DataDictManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.DataDict;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/dataDict/v1"})
@Api(tags={"\u6570\u636e\u5b57\u5178"})
@ApiGroup(group={"group_system"})
public class DataDictController
extends BaseController<DataDictManager, DataDict> {
    private static final Logger log = LoggerFactory.getLogger(DataDictController.class);
    @Resource
    DataDictManager dataDictManager;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    IdGenerator idGenerator;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    BaseContext baseContext;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b57\u5178\u5217\u8868", httpMethod="POST", notes="\u5b57\u5178\u5217\u8868")
    @ResponseBody
    public PageList<DataDict> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DataDict> queryFilter) throws Exception {
        return this.dataDictManager.query(queryFilter);
    }

    @RequestMapping(value={"dataDictEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762", httpMethod="GET", notes="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762")
    public Map<String, Object> edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, @ApiParam(name="isAdd", value="\u662f\u5426\u662f\u6dfb\u52a0") @RequestParam int isAdd, @ApiParam(name="isRoot", value="\u662f\u5426\u662f\u6839\u8282\u70b9", required=false) @RequestParam int isRoot) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isAdd", isAdd);
        DataDict dataDict = null;
        if (isRoot == 1 && isAdd == 1) {
            map.put("typeId", id);
            map.put("parentId", id);
            return map;
        }
        if (isAdd == 1 && StringUtil.isNotEmpty((String)id)) {
            map.put("parentId", id);
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
            map.put("typeId", dataDict.getTypeId());
            return map;
        }
        if (StringUtil.isNotEmpty((String)id)) {
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
            map.put("dataDict", dataDict);
            return map;
        }
        return map;
    }

    @RequestMapping(value={"getByTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178")
    @ResponseBody
    public List<DataDict> getByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        return this.getDataDict(dictType, true);
    }

    @RequestMapping(value={"getDicByDicId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u9879id\u83b7\u53d6\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u5b57\u5178\u9879id\u83b7\u53d6\u5b57\u5178\u4fe1\u606f")
    @ResponseBody
    public List<DataDict> getDicByDicId(@ApiParam(name="dicId", value="\u5b57\u5178\u9879id", required=true) @RequestBody String dicId) throws Exception {
        if (StringUtil.isEmpty((String)dicId)) {
            return null;
        }
        List list = this.dataDictManager.getDicByDicId(dicId, true);
        List<Object> rtnList = new ArrayList<DataDict>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            rtnList = BeanUtils.listToTree((List)list);
        }
        return rtnList;
    }

    @RequestMapping(value={"getByDicKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u9879key\u83b7\u53d6\u5b57\u5178", httpMethod="GET", notes="\u6839\u636e\u5b57\u5178\u9879key\u83b7\u53d6\u5b57\u5178")
    public List<DataDict> getByDicKey(@ApiParam(name="dicKey", value="\u5b57\u5178\u9879key", required=true) @RequestParam String dicKey) throws Exception {
        if (StringUtil.isEmpty((String)dicKey)) {
            return null;
        }
        List list = this.dataDictManager.getByDicKey(dicKey);
        List rtnList = BeanUtils.listToTree((List)list);
        return rtnList;
    }

    @RequestMapping(value={"moveDic"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u52a8\u5b57\u5178\u9879", httpMethod="POST", notes="\u79fb\u52a8\u5b57\u5178\u9879")
    public CommonResult<String> moveDic(@ApiParam(name="ids", value="\u5b57\u5178\u9879id\u96c6\u5408", required=true) @RequestParam List<String> ids, @ApiParam(name="gId", value="\u76ee\u6807ID", required=true) @RequestParam String gId, @ApiParam(name="type", value="\u79fb\u52a8\u7684\u7c7b\u578b\uff08dic\uff1a\u9879\uff0cval\uff1a\u503c\uff09", required=true) @RequestParam String type) throws Exception {
        if (StringUtil.isEmpty((String)gId)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u79fb\u52a8\u7684\u76ee\u6807\uff01");
        }
        if (StringUtil.isEmpty((String)type)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u79fb\u52a8\u7684\u5b57\u5178\u7c7b\u578b\uff01");
        }
        Boolean flag = this.dataDictManager.moveDic(ids, gId, type);
        if (flag.booleanValue()) {
            return new CommonResult(true, "\u79fb\u52a8\u5b57\u5178\u9879\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u79fb\u52a8\u5b57\u5178\u9879\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"getByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178")
    public List<DataDict> getByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bid", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByKey(typeKey);
        return this.getDataDict(dictType, false);
    }

    @RequestMapping(value={"getByTypeIdForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)")
    public List<DataDict> getByTypeIdForComBo(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        return rtnList;
    }

    @RequestMapping(value={"getByTypeKeyForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="POST", notes="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public List<DataDict> getByTypeKeyForComBo(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        return rtnList;
    }

    @RequestMapping(value={"getMoibleComBoByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="GET", notes="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public Map<String, Object> getMoibleComBoByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataDictList", rtnList);
        map.put("dictType", dictType);
        return map;
    }

    @RequestMapping(value={"getAllDicTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u591a\u7ef4\u6570\u636e\u5b57\u5178\u6811", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u591a\u7ef4\u6570\u636e\u5b57\u5178\u6811")
    public Map<String, List<DataDict>> getAllDicTree() throws Exception {
        List list = ((DataDictManager)this.baseService).getAllDataVal();
        List rtnList = BeanUtils.listToTree((List)list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Map<String, List<DataDict>> map = rtnList.stream().collect(Collectors.groupingBy(DataDict::getDicKey));
        return map;
    }

    @RequestMapping(value={"getAllDicVal"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u591a\u7ef4\u6570\u636e\u5b57\u5178(\u5e73\u94fa)", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u591a\u7ef4\u6570\u636e\u5b57\u5178(\u5e73\u94fa)")
    public Map<String, List<DataDict>> getAllDicVal() throws Exception {
        List list = ((DataDictManager)this.baseService).getAllDataVal();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Map<String, List<DataDict>> map = list.stream().filter(p -> p != null && StringUtil.isNotEmpty((String)p.getDicKey())).collect(Collectors.groupingBy(DataDict::getDicKey));
        return map;
    }

    private List<DataDict> getDataDict(SysType dictType, Boolean tileNeedRoot) {
        if (BeanUtils.isEmpty((Object)dictType)) {
            return null;
        }
        String typeId = dictType.getId();
        List dataDictList = this.dataDictManager.getByTypeId(typeId);
        ArrayList<DataDict> list = new ArrayList<DataDict>();
        for (DataDict entity : dataDictList) {
            DataDict dataDicts = new DataDict();
            dataDicts = entity;
            dataDicts.setOpen("true");
            List listDataDict = this.dataDictManager.getFirstChilsByParentId(dataDicts.getId());
            if (listDataDict != null && listDataDict.size() == 0) {
                dataDicts.setIsParent("false");
            }
            list.add(dataDicts);
        }
        if (tileNeedRoot.booleanValue()) {
            DataDict dict = new DataDict();
            dict.setId(dictType.getId());
            dict.setName(dictType.getName());
            dict.setTypeId(typeId);
            dict.setParentId("-1");
            dict.setKey("");
            dict.setOpen("true");
            list.add(dict);
        }
        return list;
    }

    @RequestMapping(value={"dataDictGet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9875\u9762", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9875\u9762")
    public DataDict get(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestBody String id) throws Exception {
        DataDict dataDict = new DataDict();
        if (StringUtil.isNotEmpty((String)id)) {
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
        }
        return dataDict;
    }

    @RequestMapping(value={"saveAndUpdate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    public CommonResult<String> saveAndUpdate(@ApiParam(name="dataDict", value="\u5b57\u5178", required=true) @RequestBody DataDict dataDict) throws Exception {
        String id = dataDict.getId();
        try {
            DataDict parentDict;
            String dicType = dataDict.getType();
            if (StringUtil.isEmpty((String)dicType)) {
                return new CommonResult(false, "\u8bf7\u786e\u5b9a\u5b57\u5178\u7c7b\u578b\uff01");
            }
            if (StringUtil.isEmpty((String)id)) {
                DataDict dict;
                parentDict = null;
                if (dicType.equals("dic")) {
                    dict = this.dataDictManager.getByKey("dic", dataDict.getKey(), "");
                    if (dict != null) {
                        return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u5df2\u7ecf\u5b58\u5728");
                    }
                } else if (dicType.equals("val")) {
                    parentDict = (DataDict)((DataDictManager)this.baseService).get((Serializable)((Object)dataDict.getParentId()));
                    if (parentDict == null) {
                        return new CommonResult(false, "\u3010" + dataDict.getKey() + "\u3011\u8be5\u5b57\u5178\u7684\u7236\u7ea7\u4e0d\u5b58\u5728\uff01");
                    }
                    if (StringUtil.isEmpty((String)dataDict.getDicId())) {
                        return new CommonResult(false, "\u8bf7\u9009\u62e9\u5b57\u5178\u9879\uff01");
                    }
                    dict = this.dataDictManager.getByKey("val", dataDict.getKey(), dataDict.getDicId());
                    if (dict != null) {
                        return new CommonResult(false, "\u8be5\u5b57\u5178\u503c\u5df2\u7ecf\u5b58\u5728\uff01");
                    }
                }
                if (dataDict.getSn() == null) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("parent_id_", dataDict.getParentId());
                    Integer sn = ((DataDictManager)this.baseService).getNextSequence(param);
                    dataDict.setSn(sn);
                }
                dataDict.setId(this.idGenerator.getSuid());
                if (dicType.equals("dic")) {
                    dataDict.setDicId(dataDict.getId());
                }
                if (dicType.equals("val") && dataDict.getDicId().equals(dataDict.getParentId())) {
                    dataDict.setFullId("/" + dataDict.getId());
                    dataDict.setFullCode("/" + dataDict.getKey());
                    dataDict.setFullName("/" + dataDict.getName());
                } else if (dicType.equals("val") && !dataDict.getDicId().equals(dataDict.getParentId())) {
                    dataDict.setFullId(parentDict.getFullId() + "/" + dataDict.getId());
                    dataDict.setFullCode(parentDict.getFullCode() + "/" + dataDict.getKey());
                    dataDict.setFullName(parentDict.getFullName() + "/" + dataDict.getName());
                }
                this.dataDictManager.create((Model)dataDict);
            } else {
                DataDict dict;
                parentDict = (DataDict)((DataDictManager)this.baseService).get((Serializable)((Object)dataDict.getParentId()));
                if (parentDict == null) {
                    return new CommonResult(false, "\u3010" + dataDict.getKey() + "\u3011\u8be5\u5b57\u5178\u7684\u7236\u7ea7\u4e0d\u5b58\u5728\uff01");
                }
                if (!((DataDict)this.dataDictManager.get((Serializable)((Object)id))).getKey().equals(dataDict.getKey()) && (dict = this.dataDictManager.getByDictKey(dataDict.getTypeId(), dataDict.getKey())) != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728\uff01");
                }
                if (dicType.equals("val")) {
                    if (parentDict.getType().equals("dic")) {
                        dataDict.setFullId("/" + dataDict.getId());
                        dataDict.setFullCode("/" + dataDict.getKey());
                        dataDict.setFullName("/" + dataDict.getName());
                    } else if (parentDict.getType().equals("val")) {
                        dataDict.setFullId(parentDict.getFullId() + "/" + dataDict.getId());
                        dataDict.setFullCode(parentDict.getFullCode() + "/" + dataDict.getKey());
                        dataDict.setFullName(parentDict.getFullName() + "/" + dataDict.getName());
                    }
                }
                this.dataDictManager.update((Model)dataDict);
            }
            String tenantId = this.baseContext.getCurrentTenantId();
            this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"saveAndUpdateValBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    public CommonResult<String> saveAndUpdateValBatch(@ApiParam(name="dataDict", value="\u5b57\u5178", required=true) @RequestBody List<DataDict> dataDicts) throws Exception {
        try {
            if (!CollectionUtils.isEmpty(dataDicts)) {
                for (DataDict dataDict : dataDicts) {
                    DataDict dict;
                    String id = dataDict.getId();
                    DataDict parentDict = (DataDict)((DataDictManager)this.baseService).get((Serializable)((Object)dataDict.getParentId()));
                    if (parentDict == null) {
                        return new CommonResult(false, "\u3010" + dataDict.getKey() + "\u3011\u8be5\u5b57\u5178\u7684\u7236\u7ea7\u4e0d\u5b58\u5728\uff01");
                    }
                    String dicType = dataDict.getType();
                    if (StringUtil.isEmpty((String)dicType)) {
                        return new CommonResult(false, "\u8bf7\u786e\u5b9a\u5b57\u5178\u7c7b\u578b\uff01");
                    }
                    if (StringUtil.isEmpty((String)id)) {
                        if (dicType.equals("dic")) {
                            dict = this.dataDictManager.getByKey("dic", dataDict.getKey(), "");
                            if (dict != null) {
                                return new CommonResult(false, "\u3010" + dataDict.getKey() + "\u3011\u8be5\u5b57\u5178\u9879\u5df2\u7ecf\u5b58\u5728\uff01");
                            }
                        } else if (dicType.equals("val")) {
                            if (StringUtil.isEmpty((String)dataDict.getDicId())) {
                                return new CommonResult(false, "\u8bf7\u9009\u62e9\u5b57\u5178\u9879\uff01");
                            }
                            dict = this.dataDictManager.getByKey("val", dataDict.getKey(), dataDict.getDicId());
                            if (dict != null) {
                                return new CommonResult(false, "\u3010" + dataDict.getKey() + "\u3011\u8be5\u5b57\u5178\u503c\u5df2\u7ecf\u5b58\u5728\uff01");
                            }
                        }
                        if (dataDict.getSn() == null) {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("parent_id_", dataDict.getParentId());
                            Integer sn = ((DataDictManager)this.baseService).getNextSequence(param);
                            dataDict.setSn(sn);
                        }
                        dataDict.setId(this.idGenerator.getSuid());
                        if (dicType.equals("val") && dataDict.getDicId().equals(dataDict.getParentId())) {
                            dataDict.setFullId("/" + dataDict.getId());
                            dataDict.setFullCode("/" + dataDict.getKey());
                            dataDict.setFullName("/" + dataDict.getName());
                        } else if (dicType.equals("val") && !dataDict.getDicId().equals(dataDict.getParentId())) {
                            dataDict.setFullId(parentDict.getFullId() + "/" + dataDict.getId());
                            dataDict.setFullCode(parentDict.getFullCode() + "/" + dataDict.getKey());
                            dataDict.setFullName(parentDict.getFullName() + "/" + dataDict.getName());
                        }
                        if (!dicType.equals("dic")) continue;
                        dataDict.setDicId(dataDict.getId());
                        continue;
                    }
                    if (((DataDict)this.dataDictManager.get((Serializable)((Object)id))).getKey().equals(dataDict.getKey())) continue;
                    dict = this.dataDictManager.getByDictKey(dataDict.getTypeId(), dataDict.getKey());
                    if (dict != null) {
                        return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728\uff01");
                    }
                    if (!dicType.equals("val")) continue;
                    if (parentDict.getType().equals("dic")) {
                        dataDict.setFullId("/" + dataDict.getId());
                        dataDict.setFullCode("/" + dataDict.getKey());
                        dataDict.setFullName("/" + dataDict.getName());
                        continue;
                    }
                    if (!parentDict.getType().equals("val")) continue;
                    dataDict.setFullId(parentDict.getFullId() + "/" + dataDict.getId());
                    dataDict.setFullCode(parentDict.getFullCode() + "/" + dataDict.getKey());
                    dataDict.setFullName(parentDict.getFullName() + "/" + dataDict.getName());
                }
                this.dataDictManager.saveOrUpdateBatch(dataDicts);
                String tenantId = this.baseContext.getCurrentTenantId();
                this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
                return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01");
            }
            return new CommonResult(false, "\u8bf7\u6dfb\u52a0\u5b57\u5178\u503c\uff01");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="dataDict", value="\u5b57\u5178", required=true) @RequestBody DataDict dataDict) throws Exception {
        String id = dataDict.getId();
        try {
            DataDict dict;
            if (StringUtil.isEmpty((String)id)) {
                dict = this.dataDictManager.getByDictKey(dataDict.getTypeId(), dataDict.getKey());
                if (dict != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                dataDict.setId(this.idGenerator.getSuid());
                this.dataDictManager.create((Model)dataDict);
            } else {
                if (!((DataDict)this.dataDictManager.get((Serializable)((Object)id))).getKey().equals(dataDict.getKey()) && (dict = this.dataDictManager.getByDictKey(dataDict.getTypeId(), dataDict.getKey())) != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                this.dataDictManager.update((Model)dataDict);
            }
            String tenantId = this.baseContext.getCurrentTenantId();
            this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u5b57\u5178", httpMethod="DELETE", notes="\u5220\u9664\u6570\u636e\u5b57\u5178")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u5b57\u5178", required=true) @RequestParam String id) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)id);
            this.dataDictManager.removeByIds(aryIds);
            String tenantId = this.baseContext.getCurrentTenantId();
            this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"getDataDictByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7b\u6570\u636e\u5b57\u5178", httpMethod="GET")
    public List<DataDict> getDataDictByType(@ApiParam(name="typeId", value="\u5b57\u5178", required=true) @RequestBody String typeId) throws Exception {
        List dataDictList = this.dataDictManager.getByTypeId(typeId);
        List rtnList = BeanUtils.listToTree((List)dataDictList);
        return rtnList;
    }

    @RequestMapping(value={"sortList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u5217\u8868\u9875\u9762", httpMethod="POST")
    public List<DataDict> sortList(@ApiParam(name="id", value="\u5b57\u5178", required=false, defaultValue="-1") @RequestBody String id) throws Exception {
        List dataDictList = this.dataDictManager.getFirstChilsByParentId(id);
        return dataDictList;
    }

    @RequestMapping(value={"sort"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f", httpMethod="POST")
    public CommonResult<String> sort(@ApiParam(name="dicIds", value="\u5b57\u5178", required=true) @RequestBody String[] dicIds) throws Exception {
        try {
            if (BeanUtils.isNotEmpty((Object)dicIds)) {
                for (int i = 0; i < dicIds.length; ++i) {
                    String dicId = dicIds[i];
                    int sn = i + 1;
                    this.dataDictManager.updSn(dicId, sn);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6392\u5e8f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u6392\u5e8f\u6210\u529f");
    }

    @RequestMapping(value={"removeByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u5220\u9664\u5206\u7c7b\u4e0b\u7684\u5b57\u5178", httpMethod="GET")
    public CommonResult<String> removeByTypeIds(@ApiParam(name="typeIds", value="\u5206\u7c7bid", required=true) @RequestParam String typeIds) throws Exception {
        return this.dataDictManager.removeByTypeIds(typeIds);
    }

    @RequestMapping(value={"importDic"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u9879\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u9879\u5bfc\u5165")
    public CommonResult<String> importDic(@ApiParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file) throws Exception {
        this.dataDictManager.importDic(file);
        return new CommonResult(true, "\u5bfc\u5165\u591a\u7ef4\u5b57\u5178\u9879\u6210\u529f");
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="typeId", value="\u6570\u636e\u5b57\u5178\u5206\u7c7bid", required=true) @RequestParam String typeId) throws Exception {
        this.dataDictManager.importData(file, typeId);
        return new CommonResult(true, "\u5bfc\u5165\u6570\u636e\u5b57\u5178\u6210\u529f");
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u51fa", httpMethod="GET", notes="\u6570\u636e\u5b57\u5178\u5bfc\u51fa")
    public void export(@ApiParam(name="typeId", value="\u7c7b\u578bID") @RequestParam String typeId, HttpServletResponse response) throws Exception {
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List<DataDict> dataDict = this.getDataDict(sysType, false);
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("typeKey", "\u5206\u7c7bkey");
        exportMap.put("typeName", "\u5206\u7c7b\u540d\u79f0");
        exportMap.put("parentKey", "\u7236\u7ea7\u5b57\u5178\u4ee3\u7801");
        exportMap.put("parentName", "\u7236\u7ea7\u5b57\u5178\u503c");
        exportMap.put("type", "\u5b57\u5178\u7c7b\u578b");
        exportMap.put("key", "\u5b57\u5178\u4ee3\u7801");
        exportMap.put("name", "\u5b57\u5178\u503c");
        ArrayList list = new ArrayList();
        for (DataDict dict : dataDict) {
            if (StringUtil.isEmpty((String)dict.getKey())) continue;
            DataDict parentDict = this.getKeyFromList(dict.getParentId(), dataDict);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("typeKey", sysType.getTypeKey());
            map.put("typeName", sysType.getName());
            if (parentDict != null) {
                map.put("parentKey", parentDict.getKey());
                map.put("parentName", parentDict.getName());
            } else {
                map.put("parentKey", sysType.getTypeKey());
                map.put("parentName", sysType.getName());
            }
            if (dict.getType().equals("dic")) {
                map.put("type", "\u5b57\u5178\u9879");
            } else if (dict.getType().equals("val")) {
                map.put("type", "\u5b57\u5178\u503c");
            } else {
                map.put("type", dict.getType());
            }
            map.put("key", dict.getKey());
            map.put("name", dict.getName());
            list.add(map);
        }
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u6570\u636e\u5b57\u5178", (int)dataDict.size(), exportMap, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u5b57\u5178\u5bfc\u51fa", (HttpServletResponse)response);
    }

    private DataDict getKeyFromList(String id, List<DataDict> list) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        for (DataDict dataDict : list) {
            if (!id.equals(dataDict.getId())) continue;
            return dataDict;
        }
        return null;
    }
}

