/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.datatrans;

import com.artfess.base.util.BeanUtils;
import com.artfess.form.datatrans.ITypeConvert;
import com.artfess.form.datatrans.TypeConvertConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultTransform {
    public static void transform(List list, TypeConvertConfig config) {
        Map<Class, ITypeConvert> convertMap = config.getConverts();
        if (BeanUtils.isEmpty((Object)list)) {
            return;
        }
        Object obj = list.get(0);
        if (Map.class.isAssignableFrom(obj.getClass())) {
            ResultTransform.handlerMap(list, convertMap);
        } else {
            ResultTransform.handRowObject(list, convertMap);
        }
    }

    public static void transform(List list, ITypeConvert convert) {
        if (convert == null) {
            return;
        }
        ArrayList<Object> rtnList = new ArrayList<Object>();
        for (Object tmp : list) {
            Object rtnObj = convert.processValue(tmp);
            rtnList.add(rtnObj);
        }
        list.clear();
        list.addAll(rtnList);
    }

    private static void handRowObject(List list, Map<Class, ITypeConvert> convertMap) {
        Object obj = list.get(0);
        ITypeConvert convert = ResultTransform.getConvert(convertMap, obj);
        if (convert == null) {
            return;
        }
        ArrayList<Object> rtnList = new ArrayList<Object>();
        for (Object tmp : list) {
            Object rtnObj = convert.processValue(tmp);
            rtnList.add(rtnObj);
        }
        list.clear();
        list.addAll(rtnList);
    }

    private static void handlerMap(List list, Map<Class, ITypeConvert> map) {
        Map rowMap = (Map)list.get(0);
        Map<String, ITypeConvert> convertMap = ResultTransform.getByRow(rowMap, map);
        ArrayList rtnList = new ArrayList();
        for (Object obj : list) {
            HashMap<String, Object> rtnRowMap = new HashMap<String, Object>();
            Map dataRow = (Map)obj;
            Set set = dataRow.entrySet();
            for (Map.Entry ent : set) {
                String key = (String)ent.getKey();
                Object tmp = ent.getValue();
                ITypeConvert convert = convertMap.get(key);
                if (convert == null) {
                    rtnRowMap.put(key, tmp);
                    continue;
                }
                Object rtnObj = convert.processValue(tmp);
                rtnRowMap.put(key, rtnObj);
            }
            rtnList.add(rtnRowMap);
        }
        list.clear();
        list.addAll(rtnList);
    }

    private static Map<String, ITypeConvert> getByRow(Map<String, Object> rowMap, Map<Class, ITypeConvert> convertMap) {
        HashMap<String, ITypeConvert> fieldConverMap = new HashMap<String, ITypeConvert>();
        Set<Map.Entry<String, Object>> set = rowMap.entrySet();
        for (Map.Entry<String, Object> ent : set) {
            String key = ent.getKey();
            Object obj = ent.getValue();
            ITypeConvert convert = ResultTransform.getConvert(convertMap, obj);
            if (convert == null) continue;
            fieldConverMap.put(key, convert);
        }
        return fieldConverMap;
    }

    private static ITypeConvert getConvert(Map<Class, ITypeConvert> map, Object obj) {
        Class<?> cls = obj.getClass();
        ITypeConvert convert = map.get(cls);
        if (convert != null) {
            return convert;
        }
        Set<Map.Entry<Class, ITypeConvert>> set = map.entrySet();
        for (Map.Entry<Class, ITypeConvert> ent : set) {
            if (!ent.getKey().isAssignableFrom(cls)) continue;
            return ent.getValue();
        }
        return null;
    }
}

