package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 考试状态
 */
@Getter
public enum PaperStatusEnum {
    /**
     * 未发布
     */
    notRelease("0", "未开始"),

    inTets("1", "考试中"),

    finish("2", "已结束"),


    ;

    PaperStatusEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        PaperStatusEnum[] values = values();
        for (PaperStatusEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
