/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.jms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum NoticeMessageType {
    SMS("sms", "\u77ed\u4fe1", false),
    VOICE("voice", "\u8bed\u97f3", false),
    INNER("inner", "\u7ad9\u5185\u6d88\u606f", false),
    MAIL("mail", "\u90ae\u4ef6", false),
    WXENTERPRISE("wxEnterprise", "\u5fae\u4fe1", false),
    DINGTALK("dingTalk", "\u9489\u9489", false);

    private String key;
    private String label;
    private Boolean isPlain;

    private NoticeMessageType(String key, String label, Boolean isPlain) {
        this.key = key;
        this.label = label;
        this.isPlain = isPlain;
    }

    public String key() {
        return this.key;
    }

    public String label() {
        return this.label;
    }

    public Boolean isPlain() {
        return this.isPlain;
    }

    public static NoticeMessageType[] parseNotifyType(String notifyType) {
        if (notifyType == null) {
            notifyType = "";
        }
        String[] arys = notifyType.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arys));
        return NoticeMessageType.parseNotifyType(list);
    }

    public static NoticeMessageType[] parseNotifyType(List<String> nofifyTypes) {
        ArrayList<NoticeMessageType> messageTypeArrays = new ArrayList<NoticeMessageType>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (nofifyTypes.indexOf(type.key()) <= -1) continue;
            messageTypeArrays.add(type);
        }
        NoticeMessageType[] messageTypes = new NoticeMessageType[messageTypeArrays.size()];
        messageTypeArrays.toArray(messageTypes);
        return messageTypes;
    }
}

