package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.query.dao.BizQueryTagCaseDao;
import com.artfess.query.manager.BizQueryTagCaseManager;
import com.artfess.query.model.BizQueryTagCase;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 搜索案例数据示意表【不同标签取10个即可】（BIZ_QUERY_TAG_CASE） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryTagCaseManagerImpl extends BaseManagerImpl<BizQueryTagCaseDao, BizQueryTagCase> implements BizQueryTagCaseManager {

    @Override
    @Transactional(readOnly=true)
    public PageList<BizQueryTagCase> query(QueryFilter<BizQueryTagCase> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class<BizQueryTagCase> currentModelClass = currentModelClass();
        IPage<BizQueryTagCase> result = this.baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<BizQueryTagCase>(result);
    }
}
