package com.artfess.dataShare.factory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.List;
import java.util.Map;

@Data
@ApiModel("通用数据查询返回结果")
public class QueryResultData {
    @ApiModelProperty("数据库类型")
    Integer total;

    @ApiModelProperty("查询结果数据")
    List<Map<String, Object>> data;

    @ApiModelProperty("查询字段")
    Map<String, String> field;

    @ApiModelProperty("当前页数")
    Integer pageNo=1;

    @ApiModelProperty("每页条数")
    Integer pageSize=10;
}
