package com.artfess.dataShare.dataShare.model;

import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据共享管理---每次向共享库中推送记录日志表（每次推送日志）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-29
 */
@ApiModel(value="BizSharePushdataLog对象", description="数据共享管理---每次向共享库中推送记录日志表（每次推送日志）")
@TableName("BIZ_SHARE_PUSHDATA__LOG")
@Data
public class BizSharePushdataLog extends BaseModel<BizSharePushdataLog> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据推送方式（1：Kettle 2：系统自动ETL 3：Shell推送 4：SparkSQL）")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "数据表名")
    @TableField("TABLE_NAME_")
    private String tableName;

    @TableField("数据库实体表_表名")
    private String 数据库实体表表名;

    @ApiModelProperty(value = "数据统计时间")
    @TableField("COUNT_DATE_")
    private LocalDateTime countDate;

    @ApiModelProperty(value = "数据采集完成状态（0：失败 1：成功）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "表当前数据总量")
    @TableField("TOTAL_NUM_")
    private Integer totalNum;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_time_", fill= FieldFill.INSERT, select=true)
    private LocalDateTime createTime;
}
