package com.artfess.dataShare.dataShare.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据资产--共享资源授权
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-30
 */
@ApiModel(value="BizShareAuth对象", description="数据资产--共享资源授权")
@TableName("BIZ_SHARE_AUTH")
@Data
public class BizShareAuth extends BaseModel<BizShareAuth> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "第三方需求者_ID")
    @TableField("MEMBER_ID_")
    private String memberId;

    @ApiModelProperty(value = "共享数据资源表_ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "资源共享访问方式（1：库表 2：离线文件 3：API接口）")
    @TableField("RESOURCE_TYPE_")
    private String resourceType;

    @ApiModelProperty(value = "具体资源ID(接口ID/离线文件ID)")
    @TableField("RESOURCE_ID_")
    private String resourceId;

    @TableField(exist = false)
    private BizShareConsumer consumer;

    @TableField(exist = false)
    private BizShareTable table;

    @TableField(exist = false)
    private BizShareFiles files;

    @TableField(exist = false)
    private BizShareApi api;

}
