package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.dto.ApiAuthDto;
import com.artfess.dataShare.dataShare.dto.FilesAuthDto;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.vo.ConsumerAuthVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.manager.BizShareAuthManager;

import java.util.List;

/**
 * 数据资产--共享资源授权 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-30
 */
@RestController
@RequestMapping("/biz/dateShare/shareAuth/v1/")
@Api(tags = "数据资产--共享资源授权")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareAuthController extends BaseController<BizShareAuthManager, BizShareAuth> {
    @PostMapping("auth")
    @ApiOperation("开通权限")
    public CommonResult<String> auth(@RequestBody List<BizShareAuth> list) throws Exception {
        boolean result = baseService.auth(list);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("revokeAuth")
    @ApiOperation("撤销权限")
    public CommonResult<String> revokeAuth(@RequestParam List<String> ids) throws Exception {
        boolean result = baseService.revokeAuth(ids);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("tableAuth")
    @ApiOperation("开通表查询权限")
    public CommonResult<String> tableAuth(@RequestBody List<BizShareAuth> list) throws Exception {
        boolean result = baseService.tableAuth(list);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("queryPageByConsumer")
    @ApiOperation("分页查询-需求方授权")
    public PageList<ConsumerAuthVo> queryPageByConsumer(@RequestBody QueryFilter<BizShareAuth> queryFilter,
                                                        @RequestParam String consumerId,
                                                        @RequestParam String resourceType){
        PageList<ConsumerAuthVo> pageList = baseService.queryPageByConsumer(queryFilter,consumerId,resourceType);
        return pageList;
    }

    @PostMapping("queryPageByResource")
    @ApiOperation("分页查询-资源授权")
    public PageList<ConsumerAuthVo> queryPageByResource(@RequestBody QueryFilter<BizShareAuth> queryFilter,
                                                          @RequestParam String resourceId,
                                                          @RequestParam String resourceType){
        PageList<ConsumerAuthVo> pageList = baseService.queryPageByResource(queryFilter,resourceId,resourceType);
        return pageList;
    }

    @PostMapping("/queryTableAuth")
    @ApiOperation("分页查询-已给需求方授权的表资源")
    public PageList<TableAuthDto> queryTableAuth(@RequestBody QueryFilter<BizShareAuth> queryFilter,
                                                 @RequestParam("consumerId") String consumerId){
        PageList<TableAuthDto> pageList = baseService.queryTableAuth(queryFilter,consumerId);
        return pageList;
    }

    @PostMapping("/queryApiAuth")
    @ApiOperation("分页查询-已给需求方授权的接口资源")
    public PageList<ApiAuthDto> queryApiAuth(@RequestBody QueryFilter<BizShareAuth> queryFilter,
                                             @RequestParam("consumerId") String consumerId){
        PageList<ApiAuthDto> pageList = baseService.queryApiAuth(queryFilter,consumerId);
        return pageList;
    }

    @PostMapping("/queryFilesAuth")
    @ApiOperation("分页查询-已给需求方授权的文件资源")
    public PageList<FilesAuthDto> queryFilesAuth(@RequestBody QueryFilter<BizShareAuth> queryFilter,
                                                 @RequestParam("consumerId") String consumerId){
        PageList<FilesAuthDto> pageList = baseService.queryFilesAuth(queryFilter,consumerId);
        return pageList;
    }
}
