package com.artfess.dataShare.dataResource.ods.manager;

import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.base.manager.BaseManager;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据资源-- ODS字段信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
public interface BizOdsFieldManager extends BaseManager<BizOdsField> {
    /**
     * 根据实体表Id查询字敦
     * @param tableId
     * @return
     */
    List<BizOdsField> queryFieldByTableId(String tableId);

    /**
     * 根据表导入表字段
     * @param file
     * @param tableId
     * @throws Exception
     */
    void export(MultipartFile file, String tableId) throws Exception;

    /**
     * 批量维护数据字段信息
     * @param field
     */
    void saveOrUpdates(List<BizOdsField> field);

    /**
     * 修改发布后的表字段信息-同时要修改实体表
     * @param field
     */
    void saveOrUpdateFields(List<BizOdsField> field) throws Exception;
}
