package com.artfess.dataShare.dataCollect.dao;

import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

/**
 * 数据汇聚表信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
public interface BizClusterTableDao extends BaseMapper<BizClusterTable> {

    /**
     * 数据汇聚表信息（分页 ）
     *
     * @param iPage
     * @param wrapper
     * @return
     */
    IPage<BizClusterTable> getClusterTableQueryList(IPage<BizClusterTable> iPage, @Param(Constants.WRAPPER) Wrapper<BizClusterTable> wrapper);
}
