package com.artfess.dataShare.dataApi.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataApi.vo.RespParamVo;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 数据资产-数据服务接口信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-11-22
 */
@ApiModel(value="BizServiceApi对象", description="数据资产-数据服务接口信息")
@TableName("BIZ_SERVICE_API")
@Data
public class BizServiceApi extends AutoFillModel<BizServiceApi> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    @ApiModelProperty(value="主键")
    private String id;

    @NotBlank(message = "请选择目录！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "目录ID")
    @TableField("CATALOG_ID_")
    private String catalogId;

    @NotBlank(message = "请选择数据源！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "数据源别名")
    @TableField("DB_ALIAS_")
    private String dbAlias;

    @NotBlank(message = "接口名称不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "接口名称")
    @TableField("API_NAME_")
    private String apiName;

    @NotBlank(message = "接口编码不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "接口编码")
    @TableField("API_CODE_")
    private String apiCode;

    @ApiModelProperty(value = "接口描述")
    @TableField("API_DESC_")
    private String apiDesc;

    @NotBlank(message = "接口地址不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "接口地址")
    @TableField("API_URL_")
    private String apiUrl;

    @NotNull(message = "请求方式不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "请求方式（POST、GET、DELETE、PUT）")
    @TableField("API_MODE_")
    private RequestMethod apiMode;

    @NotNull(message = "接口查询方式不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "接口查询方式（0：不分页，1：分页）")
    @TableField("API_QUREY_TYPE_")
    private Integer apiQureyType;

    @NotBlank(message = "SQL查询语句不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "SQL查询语句")
    @TableField("API_SQL_")
    private String apiSql;

    @ApiModelProperty(value = "请求头说明")
    @TableField("REQUEST_HEADER_")
    private String requestHeader;

    @ApiModelProperty(value = "请求参数说明")
    @TableField("REQUEST_PARAMS_")
    private String requestParams;

    @ApiModelProperty(value = "请求参数样例")
    @TableField("REQUEST_EXAMPLE_")
    private String requestExample;

    @ApiModelProperty(value = "响应状态码信息")
    @TableField("RESPONSE_STATUS_")
    private String responseStatus;

    @ApiModelProperty(value = "返回参数说明")
    @TableField("RESPONSE_PARAMS_")
    private String responseParams;

    @ApiModelProperty(value = "返回数据样例")
    @TableField("RESPONSE_EXAMPLE_")
    private String responseExample;

    @TableField(exist = false)
    private RespParamVo respParamVo;

    @ApiModelProperty(value = "接口状态（0：下架，1：正式）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;

//    @ApiModelProperty(value = "创建人")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建单位")
//    @TableField("CREATE_ORG_ID_")
//    private String createOrgId;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "修改人员")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "修改单位")
//    @TableField("UPDATE_ORG_ID_")
//    private String updateOrgId;
//
//    @ApiModelProperty(value = "修改时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;
//
    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
