package com.artfess.dataShare.dataShare.dao;

import com.artfess.base.query.PageList;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据共享管理--共享资源表管理 （元数据信息+TABLE信息） Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
public interface BizShareTableDao extends BaseMapper<BizShareTable> {

    /**
     * @Description: 根据定时任务查询关联的ODS数据项
     * @param jobId
     * @Return: java.util.List<com.artfess.dataShare.dataResource.ods.model.BizOdsTable>
     * @Author: chens
     * @Date: 2025/1/4 11:54:40
     */
    List<BizShareTable> queryByJob(@Param("jobId") String jobId);

    IPage<BizShareTable> queryAuthPage(IPage<BizShareTable> convert2IPage,
                                          @Param(Constants.WRAPPER) Wrapper<BizShareTable> convert2Wrapper,
                                          @Param("consumerId") String consumerId);

    int updateCatalog(@Param("ids") String[] ids, @Param("catalogId") String catalogId);
}
