package com.artfess.dataShare.dataResource.app.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.poi.annotation.Excel;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;

/**
 * 数据DW字段信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
@Data
@ApiModel(value="BizDWField对象", description="数据DW字段信息")
public class BizAppFieldVo {

    @Excel(name ="*字段英文名")
    private String fieldCode;

    @Excel(name ="*字段中文名")
    private String name;

    @Excel(name ="*字段编码")
    private String code;

    @Excel(name ="*字段描述（字段备注释义）")
    private String desc;

    @Excel(name ="*数据类型",readConverterExp = "varchar=字符串,number=数字,date=日期")
    private String dataType;

    @Excel(name ="字段默认值")
    private String defaultValue;

    @Excel(name ="数据长度")
    private Integer attrLength;

    @Excel(name ="是否主键",readConverterExp = "0=否,1=是")
    private String isPk;

    @Excel(name ="是否允许为空",readConverterExp = "0=否,1=是")
    private String isRequired;

    @Excel(name ="是否存储加密",readConverterExp = "0=否,1=是")
    private String isEncrypt;

    @Excel(name ="是否脱敏",readConverterExp = "0=否,1=是")
    private String isDesensitize;

    @Excel(name ="数据精度")
    private Integer decimalLen;

    @Excel(name ="*字段类别",readConverterExp = "1=管理字段,2=业务字段")
    private String fieldType;

    @Excel(name ="序号")
    private Integer sn;

    @Excel(name ="备注")
    private String remark;

    public static BizAppCatalogsTableField parse(BizAppFieldVo roleVo){
        BizAppCatalogsTableField vo = new BizAppCatalogsTableField();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }


}
