package com.artfess.dataShare.dataResource.app.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsTableFieldDao;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableFieldManager;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableManager;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.dataShare.dataResource.app.vo.BizAppFieldVo;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import com.artfess.dataShare.util.Constants;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 数据应用层--APP层数据表字段信息（字段） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
@Service
public class BizAppCatalogsTableFieldManagerImpl extends BaseManagerImpl<BizAppCatalogsTableFieldDao, BizAppCatalogsTableField> implements BizAppCatalogsTableFieldManager {
    @Autowired
    BizAppCatalogsTableManager tableManager;

    @Transactional(rollbackFor = Exception.class )
    public void export(MultipartFile file, String tableId) throws Exception{
        BizAppCatalogsTable table = tableManager.get(tableId);
        String tableName=table.getTableNameEn();
        ExcelTool<BizAppFieldVo> util = new ExcelTool<>(BizAppFieldVo.class);
        List<BizAppFieldVo> list = util.importExcel(file.getInputStream(),2,2);
        list = list.stream().filter(vo->StringUtil.isNotEmpty(vo.getFieldCode())).collect(Collectors.toList());
        for(int i=1;i<list.size();i++){
            BizAppFieldVo vo = list.get(i);
            if(checkExistsField(tableId,vo.getFieldCode())){
                throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+vo.getFieldCode()+")】请修改后在导入");
            }
        }
        List<String> disFieldList=list.stream().map(p->p.getFieldCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<list.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        for(int i=1;i<list.size();i++){
            BizAppFieldVo vo = list.get(i);
            if(StringUtil.isEmpty(vo.getFieldCode())){
                continue;
            }
            BizAppCatalogsTableField field = vo.parse(vo);
            field.setTableId(tableId);
            //field.setDataType(vo.getDataType());
            //field.setCode(field.getName());
            //field.setDataType(FieldUtil.getColumnType(field.getDataType()));
            if("管理字段".equals(vo.getFieldType())){
                field.setFieldType("1");
            }else if("业务字段".equals(vo.getFieldType())){
                field.setFieldType("2");
            }
            //创建字段
            Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
            Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
            String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
            field.setFlSql(fieldSq);
            field.setMouldName(table.getName());
            field.setMouldCode(table.getCode());
            field.setCode(field.getFieldCode());
            field.setIsDele("0");
            this.create(field);
        }
        //String alertFieSQl="ALTER TABLE `w_jyjh` ADD COLUMN `name` varchar(32) NOT NULL";

    }

    public boolean checkExistsField(String tableId,String fieldName){
        QueryWrapper<BizAppCatalogsTableField> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_ID_",tableId);
        queryWrapper.eq("FIELD_CODE_",fieldName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    public boolean checkExistsField(String tableId,String fieldName,String id){
        QueryWrapper<BizAppCatalogsTableField> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_ID_",tableId);
        queryWrapper.eq("FIELD_CODE_",fieldName);
        queryWrapper.ne("ID_",id);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    public List<BizAppCatalogsTableField> queryFieldByTableId(String tableId) {
        QueryWrapper<BizAppCatalogsTableField> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("table_id_", tableId);
        queryWrapper.orderByAsc("sn_");
        return this.list(queryWrapper);
    }

    @Transactional(rollbackFor = Exception.class )
    public void saveTableField(BizAppTableDetailVo vo){
        BizAppCatalogsTable table = vo.getTable();
        List<BizAppCatalogsTableField> listField=vo.getFieldList();
        List<String> disFieldList=listField.stream().map(p->p.getFieldCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<listField.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        if(StringUtil.isEmpty(table.getId())){
            tableManager.create(table);
        }else{
            tableManager.update(table);
        }
        for(BizAppCatalogsTableField item : listField){
            if(StringUtil.isEmpty(item.getId())){
                if(checkExistsField(table.getTableNameEn(),item.getFieldCode())){
                    throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+item.getFieldCode()+")】请修改后在导入");
                }
            }else{
                if(checkExistsField(table.getTableNameEn(),item.getFieldCode(),item.getId())){
                    throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+item.getFieldCode()+")】请修改后在导入");
                }
            }
            item.setTableId(table.getId());
            item.setFieldType("2");
        }
        this.saveOrUpdateBatch(listField);
    }

    @Override
    public void saveOrUpdates(List<BizAppCatalogsTableField> field) {
        List<String> disFieldList=field.stream().map(p->p.getFieldCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<field.size()){
            throw new BaseException("表中存在重复字段名请修改后在保存");
        }
        String tableId = field.get(0).getTableId();
        List<BizAppCatalogsTableField> oldFields = this.queryFieldByTableId(tableId);
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0){
            removeByIds(oldFields.stream().filter(p->"2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }
        //表里面没有字段的时候才加默认的管理字段
        if(oldFields.size()==0){
            addManageField(oldFields);
        }
        for(BizAppCatalogsTableField item : field){
            if(StringUtil.isEmpty(item.getId())){
                if(checkExistsField(tableId,item.getFieldCode())){
                    throw new BaseException("表中存在字段("+item.getFieldCode()+")请修改后在导入");
                }
            }else{
                if(checkExistsField(tableId,item.getFieldCode(),item.getId())){
                    throw new BaseException("表中存在字段("+item.getFieldCode()+"请修改后在导入");
                }
            }
            item.setTableId(tableId);
            item.setFieldCode(item.getCode());
            item.setId(null);
        }
        if(field.size()>0) {
            this.saveBatch(field);
        }
    }

    private void addManageField(List<BizAppCatalogsTableField> fieldList){
        BizAppCatalogsTableField createBy = new BizAppCatalogsTableField();
        createBy.setFieldCode("CREATE_BY_");
        createBy.setName("创建人");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("创建人");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsRequired("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");

        BizAppCatalogsTableField createOrgId = new BizAppCatalogsTableField();
        createOrgId.setFieldCode("CREATE_ORG_ID_");
        createOrgId.setName("创建单位");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("创建单位");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsRequired("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");

        BizAppCatalogsTableField createTime = new BizAppCatalogsTableField();
        createTime.setFieldCode("CREATE_TIME_");
        createTime.setName("创建时间");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("创建时间");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsRequired("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");

        BizAppCatalogsTableField id = new BizAppCatalogsTableField();
        id.setFieldCode("ID_");
        id.setName("主键");
        id.setCode("ID_");
        id.setDesc("主键");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsRequired("0");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);

        Set<String> set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())){
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())){
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())){
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())){
            fieldList.add(id);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdateFields(List<BizAppCatalogsTableField> fields) throws Exception {
        if(fields.size()==0){
            throw  new ApplicationException("没有修改的字段");
        }
        String tableId = fields.get(0).getTableId();
        BizAppCatalogsTable table = tableManager.get(tableId);
        List<String> disFieldList=fields.stream().map(p->p.getFieldCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<fields.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        String tableName=table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.APP_DATA_SOURCE_ALIAS);

        for(BizAppCatalogsTableField field : fields){
            field.setIsCreate("1");
            //创建字段
            Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
            Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldCode(field.getCode());
            //新镇字段
            if(StringUtil.isEmpty(field.getId())){
                if(field.getSn()==null){
                    Map<String,Object> map=new HashMap<>();
                    map.put("TABLE_ID_",tableId);
                    field.setSn(this.getNextSequence(map));
                }
                field.setMouldCode(fields.get(0).getMouldCode());
                field.setMouldName(fields.get(0).getMouldName());
                String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
                field.setFlSql(fieldSq);
                template.execute(fieldSq);
            }else if(fieldEquals(field)){
                BizAppCatalogsTableField oldField = this.getById(field.getId());
                //修改字段名
                if(!field.getFieldCode().equals(oldField.getFieldCode())){
                    //ALTER TABLE app_user_info CHANGE COLUMN `USER_PHONE_` `USER_PHONE_1_` varchar COMMENT '移动手机号';
                    String fieldSq="ALTER TABLE `"+tableName+"` RENAME COLUMN `"+oldField.getFieldCode()+"` `"+ field.getFieldCode() +"` ";
                  //  String fieldSq="ALTER TABLE `"+tableName+"` CHANGE `"+oldField.getFieldCode()+"`  `"+ field.getFieldCode() +"` "+FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength,
                  //          decimalLen)+" DEFAULT NULL COMMENT '"+field.getDesc()+"' ";
                    template.execute(fieldSq);
                }
                //
                if(!field.getDesc().equals(oldField.getDesc())){
                    //ALTER TABLE app_user_info MODIFY COLUMN `USER_PHONE_` varchar COMMENT '移动手机号';
                    String fieldSq="ALTER TABLE `"+tableName+"` MODIFY COLUMN `"+field.getFieldCode()+"`  COMMENT "+field.getDesc()+" ";
                    template.execute(fieldSq);
                }
            }
        }
        this.saveOrUpdateBatch(fields);
        //更新建表语句
        String createSql = DorisUtils.createAppTable(template, table.getTableNameEn(),table.getTableDesc(), fields);
        table.setCreateTableSql(createSql);
        table.setFieldTotal(fields.size());
        this.tableManager.updateById(table);
    }

    //判断传过来的字段是不是修改了
    public boolean fieldEquals(BizAppCatalogsTableField field){
        BizAppCatalogsTableField oldField = this.getById(field.getId());
        if(!field.getFieldCode().equals(oldField.getFieldCode())
                || !field.getDesc().equals(oldField.getDesc())
        ){
            return true;
        }
        return false;
    }
}
