package com.artfess.dataShare.dataCollect.vo;

import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.poi.annotation.Excel;
import io.swagger.annotations.ApiModel;

/**
 * 数据汇聚表信息
 *
 * @author WH
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-11-07
 */
@ApiModel(value = "BizClusterTable对象", description = "数据汇聚表信息")
public class BizClusterTableVo {

    //*顺序码	*数据资源项名称	*数据资源项代码(唯一值)	*数据资源分类	数据资源项描述	*资源密级程度	*数据提供方式	*数据库表中文名	"*数据库表英文名(唯一值)	数据库表描述	*数据库表类型	*更新周期频率

    @Excel(name = "*顺序码")
    private Integer sn;
    @Excel(name = "*数据资源项名称")
    private String name;
    @Excel(name = "*数据资源项代码(唯一值)")
    private String code;
    @Excel(name = "*数据资源分类",readConverterExp = "1=电子文件,2=电子表格,3=数据库,4=图形图像,5=流媒体,6=其它")
    private String sourceType;

    @Excel(name = "数据资源项描述")
    private String description;

    @Excel(name = "*资源密级程度",readConverterExp = "1=低,2=中,3=较高,4=高")
    private String level;

    @Excel(name = "*数据提供方式",readConverterExp = "1=数据库,2=接口,3=离线文件,4=消息中间件")
    private String source;

    @Excel(name = "*数据库表中文名")
    private String tableCn;

    @Excel(name = "*数据库表英文名(唯一值)")
    private String tableName;

    @Excel(name = "*数据库表描述")
    private String desc;

    @Excel(name = "*数据库表类型",readConverterExp = "1=主表,2=子表")
    private String tableType;

    @Excel(name = "*更新周期频率")
    private String updateRate;

    public static BizClusterTable parseTable(BizClusterTableVo roleVo){
        BizClusterTable vo = new BizClusterTable();
        vo.setName(roleVo.getName());
        vo.setCode(roleVo.getCode());
        vo.setSn(roleVo.getSn());
        vo.setDescription(roleVo.getDesc());
        vo.setTableNameCh(roleVo.getTableCn());
        vo.setTableNameEn(roleVo.getTableName());
        vo.setTableType(roleVo.getTableType());
        return vo;
    }

    /*public static BizClusterMould parseMould(BizClusterTableVo roleVo){
        BizClusterMould vo = new BizClusterMould();
        vo.setName(roleVo.getName());
        vo.setDescription(roleVo.getDescription());
        vo.setSource(roleVo.getSource());
        vo.setSourceType(roleVo.getSourceType());
        vo.setLevel(roleVo.getLevel());
        vo.setUpdateRate(roleVo.getUpdateRate());
        vo.setSn(roleVo.getSn());
        return vo;
    }*/

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTableCn() {
        return tableCn;
    }

    public void setTableCn(String tableCn) {
        this.tableCn = tableCn;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTableType() {
        return tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getUpdateRate() {
        return updateRate;
    }

    public void setUpdateRate(String updateRate) {
        this.updateRate = updateRate;
    }

    @Override
    public String toString() {
        return "BizClusterTableVo{" +
                "sn=" + sn +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", sourceType='" + sourceType + '\'' +
                ", description='" + description + '\'' +
                ", level='" + level + '\'' +
                ", source='" + source + '\'' +
                ", tableCn='" + tableCn + '\'' +
                ", tableName='" + tableName + '\'' +
                ", desc='" + desc + '\'' +
                ", tableType='" + tableType + '\'' +
                ", updateRate='" + updateRate + '\'' +
                '}';
    }
}
