package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.Column;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.*;
import com.artfess.dataShare.dataCollect.dao.BizClusterTableDao;
import com.artfess.dataShare.dataCollect.manager.*;
import com.artfess.dataShare.dataCollect.model.*;
import com.artfess.dataShare.dataCollect.vo.BizClusterTableVo;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import com.artfess.dataShare.dataResource.ods.vo.CopyTableVo;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.dataShare.util.MySQLUtils;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据汇聚表信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
@Service
public class BizClusterTableManagerImpl extends BaseManagerImpl<BizClusterTableDao, BizClusterTable> implements BizClusterTableManager {

    @Resource
    BizClusterInfoModeManager infoModeManager;

    @Resource
    BizClusterInfoManager infoManager;

    @Resource
    BizClusterTableFieldManager fieldManager;

    @Resource
    BizClusterTempDataLogManager tempDataLogManager;

    @Resource
    BizClusterTableTriggerManager triggerManager;


    public boolean checkTable(String tableName){
        QueryWrapper<BizClusterTable> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_NAME_EN_",tableName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    public boolean checkTableCode(String code){
        QueryWrapper<BizClusterTable> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("CODE_",code);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    /**
     * 批量导入数据资源项目录清单
     * 读取到数据后同时生成【数据汇聚模型信息】和【数据汇聚表信息】两个表
     * 同时往宏天的下列表写入数据
     * 实体表  form_bo_ent
     * 业务模型 form_bo_def
     *
     * 修改form_bo_def表 增加数据源别名
     *
     * @param file
     */
    @Transactional(rollbackFor = Exception.class )
    public void export(MultipartFile file,String clusterInfoId) throws Exception {
        ExcelTool<BizClusterTableVo> util = new ExcelTool<BizClusterTableVo>(BizClusterTableVo.class);
        List<BizClusterTableVo> list = util.importExcel(file.getInputStream(),3,4);
        list=list.stream().filter(p-> org.apache.commons.lang3.StringUtils.isNotBlank(p.getTableName())).collect(Collectors.toList());
        if(list.size()==0){
            throw new BaseException("表没有检测到需要导入的数据，注意中文名不能为空。");
        }
        //判断表名是否存在
        for(BizClusterTableVo vo : list){
            if(StringUtil.isEmpty(vo.getTableCn())){
                continue;
            }
            if(StringUtil.isEmpty(vo.getTableCn())){
                throw new BaseException("表"+vo.getName()+"中文名不能为空");
            }
            if(StringUtil.isEmpty(vo.getTableName())){
                throw new BaseException("表"+vo.getName()+"英文名不能为空");
            }
            if(checkTable(vo.getTableName())){
                throw new BaseException("表【"+vo.getName()+"("+vo.getTableName()+")】已经存在");
            }
            if(checkTableCode(vo.getCode())){
                throw new BaseException("表【"+vo.getName()+"("+vo.getCode()+")】已经存在");
            }
        }
        for(BizClusterTableVo vo : list){
            if(StringUtil.isEmpty(vo.getCode())){
                continue;
            }
            //System.out.println(vo.toString());

            BizClusterTable table=vo.parseTable(vo);
            //BizClusterMould mould=vo.parseMould(vo);
            //BizClusterInfo info=infoManager.queryByName(vo.getInfoName());
//            BizClusterInfoMode infoMode=infoModeManager.getById(clusterInfoId);
//            if(null!=infoMode) {
//                mould.setClusterId(infoMode.getId());
//                mould.setDbSourceId(infoMode.getDatabaseAlias());
//            }
            //发布的时候建表
            /*Map<String,String> idsMap=createMouldAndTable(vo.getName(),vo.getCode(),vo.getDesc(),info.getDatabaseAlias());
            mould.setId(idsMap.get("defId"));
            table.setId(idsMap.get("tableId"));
            table.setMouldId(mould.getId());
            table.setIsCreateTable(1);*/
            BizClusterInfo info=infoManager.getById(clusterInfoId);
            BizClusterInfoMode infoMode=infoModeManager.getById(clusterInfoId);
            table.setDbSourceId(infoMode.getDatabaseAlias());
            table.setTableNameCh(vo.getTableCn());
            table.setTableNameEn(info.getSysTableCode()+"_"+table.getTableNameEn());
            table.setClusterId(clusterInfoId);
            table.setIsCreateTable(0);
            table.setDeployed(0);
            table.setIsDele("0");
            table.setTablePrefixCode(info.getSysTableCode());
            this.create(table);

        }
    }

    //发布的时候建表
    @Transactional(rollbackFor = Exception.class )
    public void Deploy(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizClusterTable table= this.getById(tableId);
        if("1".equals(table.getDeployed())){
            throw new ApplicationException("表已经发布，不能重复发布");
        }
        //BizClusterMould module= this.mouldManager.getById(table.getMouldId());
        //List<BizClusterField> fieldList = fieldManager.queryFieldByTableId(tableId);
        List<BizClusterTableField> fieldList = fieldManager.queryFieldByTableId(tableId);
        if(fieldList.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        BizClusterInfoMode info=infoModeManager.getById(table.getClusterId());
       /* BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }*/
        //获取共享库数据源
        //JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(info.getDatabaseAlias());
        //BizDatasourcesRelation dataSourceRelation=dataSourceRelationManager.queryBizDataSourceByType(1);
        BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());

        table.setIsCreateTable(1);
        //table.setTableName("w_"+table.getTableName());
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(queryTableSql(tableId));

        template.execute(table.getCreateTableSql());
        this.update(table);
        //String categoryId="31063";
        //String categoryName="默认分类";

        //2014、12、15 laowang 不同步表到宏天去
        //Map<String,String> idsMap= SyncTableUtil.createMouldAndTable(jdbcTemplate,template,table.getId(),table.getId(),table.getTableNameEn(),table.getCode(),table.getDescription(),dataSourceRelation.getAlias(),fieldList,categoryId,categoryName);
        //mould.setId(idsMap.get("defId"));
        //table.setId(idsMap.get("tableId"));
        //table.setMouldId(mould.getId());

        //获取共享库数据源
        //JdbcTemplate rootJemplate = DataSourceUtil.getJdbcTempByDsAlias(info.getDatabaseAlias());
        //创建触发器记录日志  操作管理员才能创建触发器，所以这里用获取共享库数据源的root权限操作
        Map<String,String> triggerMap=MySQLUtils.createTiger(template,table.getTableNameEn(),info.getCompanyName(),info.getSysName(),info.getSysCode(),table.getName(),table.getCode());

        BizClusterTableTrigger triggerInsert=new BizClusterTableTrigger();
        triggerInsert.setIsCreateTable(1);
        triggerInsert.setMouldCode(table.getCode());
        triggerInsert.setMouldName(table.getTableNameCh());
        triggerInsert.setTableId(tableId);
        triggerInsert.setTriggerSql(triggerMap.get("insert"));
        triggerInsert.setTriggerType("1");
        triggerInsert.setName(table.getTableNameCh()+"添加数据触发器");
        triggerInsert.setCode(table.getTableNameEn()+"_insert_tiger");
        triggerManager.create(triggerInsert);

        BizClusterTableTrigger triggerUpdate=new BizClusterTableTrigger();
        triggerUpdate.setIsCreateTable(1);
        triggerUpdate.setMouldCode(table.getCode());
        triggerUpdate.setMouldName(table.getTableNameCh());
        triggerUpdate.setTableId(tableId);
        triggerUpdate.setTriggerSql(triggerMap.get("update"));
        triggerUpdate.setTriggerType("2");
        triggerUpdate.setName(table.getTableNameCh()+"修改数据触发器");
        triggerUpdate.setCode(table.getTableNameEn()+"_update_tiger");
        triggerManager.create(triggerUpdate);

        BizClusterTableTrigger triggerDelete=new BizClusterTableTrigger();
        triggerDelete.setIsCreateTable(1);
        triggerDelete.setMouldCode(table.getCode());
        triggerDelete.setMouldName(table.getTableNameCh());
        triggerDelete.setTableId(tableId);
        triggerDelete.setTriggerSql(triggerMap.get("delete"));
        triggerDelete.setTriggerType("3");
        triggerDelete.setName(table.getTableNameCh()+"添加数据触发器");
        triggerDelete.setCode(table.getTableNameEn()+"_delete_tiger");
        triggerManager.create(triggerDelete);
    }

    /*public Map<String,String> createMouldAndTable(String tableId,String moduleId,String name,String code,String desc,String dbAlias,List<BizClusterField> fieldList) throws IOException {
        //封装json  模型
        Map<String,Object> boDef=new HashMap<>();
        boDef.put("createBy",null);
        boDef.put("createTime",null);
        boDef.put("updateBy",null);
        boDef.put("updateTime",null);
        boDef.put("id",moduleId);
        boDef.put("alias",code);
        boDef.put("description",desc);
        boDef.put("supportDb", true);
        boDef.put("categoryId","31063");
        boDef.put("categoryName","默认分类");
        boDef.put("status","normal");
        boDef.put("dbAlias",dbAlias);
        boDef.put("deployed",true);
        boDef.put("rev",14);
        boDef.put("pkVal",moduleId);

        //表
        Map<String,Object> boEnt=new HashMap<>();
        boEnt.put("id",tableId);
        boEnt.put("name",code);
        boEnt.put("desc",desc);
        boEnt.put("packageId","");
        boEnt.put("dsName",null);
        boEnt.put("tableName",code);
        boEnt.put("isExternal",0);
        boEnt.put("status","actived");
        boEnt.put("pk",null);
        boEnt.put("fk","ref_id_");
        boEnt.put("pk_type",null);
        boEnt.put("type","main");
        boEnt.put("tableNameNoPrefix",null);
        boEnt.put("dbAlias",dbAlias);
        boEnt.put("show","主实体");
        boEnt.put("relation","main");
        boEnt.put("canEditTable",false);
        boEnt.put("comment",desc);
        boEnt.put("createdTable",false);
        boEnt.put("external",false);
        boEnt.put("pkKey","id_");
        boEnt.put("fieldPrefix","F_");
        boEnt.put("pkNumber",false);
        boEnt.put("pkVal",tableId);
        List<Map<String,Object>> fieldMapList=new ArrayList<>();
        //封装字段信息
        for(BizClusterField field : fieldList){
            Map<String,Object> fieldMap=new HashMap<>();
            fieldMap.put("id",field.getId());
            fieldMap.put("entId",tableId);
            fieldMap.put("name",field.getFieldName());
            fieldMap.put("desc",field.getDesc());
            fieldMap.put("dataType",getColumnType(field.getDataType()));
            fieldMap.put("defaultValue",field.getDefaultValue());
            fieldMap.put("format",field.getFormat());
            fieldMap.put("isRequired",0);
            fieldMap.put("attrLength",field.getAttrLength());
            fieldMap.put("decimalLen", field.getDecimalLen());
            fieldMap.put("sn",field.getSn());
            fieldMap.put("fieldName","F_"+field.getFieldName());
            fieldMap.put("status", null);
            fieldMap.put("index", 6);
            fieldMap.put("fcolumnType", null);
            fieldMap.put("isPk", false);
            fieldMap.put("isNull", false);
            fieldMap.put("tableName","");
            fieldMap.put("comment",field.getDesc());
            fieldMap.put("charLen", field.getAttrLength());
            fieldMap.put("columnType",getColumnType(field.getDataType()));
            fieldMap.put("intLen",field.getAttrLength());
            fieldMap.put("pkVal",field.getId());
            fieldMapList.add(fieldMap);
        }

        boEnt.put("attributeList",fieldMapList);
        boEnt.put("childEnts",new ArrayList<>());
        List<Map<String,Object>> boEnts=new ArrayList<>();
        boEnts.add(boEnt);
        boDef.put("boEnt",boEnt);
        boDef.put("ents",boEnts);
        System.out.println(boDef);
        //Map<String,Object> ent=new HashMap<>();
        //ObjectMapper objectMapper=new ObjectMapper();
        //ObjectNode objectNode=objectMapper.convertValue(boDef,ObjectNode.class);

        JsonNode objectNode=JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        //objectNodes.add(objectNode);
        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNew(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String odsTableId=jdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);
        //BoDef boDef = new BoDef();
        //BoEnt boEnt = new BoEnt();
        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",odsTableId);
        return map;
    }

    public String getColumnType(String columnType) {
        if ("字符串".equalsIgnoreCase(columnType)) {
            return "varchar";
        } else if ("小数".equalsIgnoreCase(columnType)) {
            return "decimal";
        } else if ("日期".equalsIgnoreCase(columnType)) {
            return "date";
        }else if ("数值".equals(columnType)||"数字".equals(columnType)) {
            return "number";
        } else if ("文本".equalsIgnoreCase(columnType)) {
            return "text";
        } else {
            return "";
        }
    }*/
    @Transactional(rollbackFor = Exception.class )
    public void saveTableVo(TableDetailVo vo){
        BizClusterTable table=vo.getTable();
        //BizClusterMould mould=vo.getMould();
        //this.mouldManager.saveOrUpdate(mould);
        //table.setMouldId(mould.getId());
        this.saveOrUpdate(table);
        List<BizClusterTableField> oldFields = fieldManager.queryFieldByTableId(table.getId());
        //删除原来的表字段
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0){
            //只删除业务字段
            fieldManager.removeByIds(oldFields.stream().filter(p->"2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }

        List<BizClusterTableField> listField = vo.getFieldList();
        //表里面没有字段的时候才加默认的管理字段
        if(oldFields.size()==0){
            addManageField(listField);
        }
        for(BizClusterTableField item : listField){
            item.setTableId(table.getId());
            item.setFieldName(item.getCode());
            item.setId(null);
        }
        if(listField.size()>0){
            this.fieldManager.saveBatch(listField);
        }
    }

    public TableDetailVo queryTableVo(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        TableDetailVo vo = new TableDetailVo();
        BizClusterTable table=this.getById(tableId);
        if(null==table){
            throw new BaseException("未查询到表");
        }
        vo.setTable(table);
        //vo.setMould(this.mouldManager.getById(table.getMouldId()));
        vo.setFieldList(this.fieldManager.queryFieldByTableId(tableId));
        return vo;

    }

    /**
     * 手动建表
     */
    @Transactional(rollbackFor = Exception.class )
    public void createdTable(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizClusterTable table= this.getById(tableId);
        //BizClusterMould module= this.mouldManager.getById(table.getMouldId());
        List<BizClusterTableField> fieldList = fieldManager.queryFieldByTableId(tableId);
        BizClusterInfoMode info=infoModeManager.getById(table.getClusterId());
        /*BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }*/
        //获取共享库数据源
        JdbcTemplate template=DataSourceUtil.getJdbcTempByDsAlias(info.getDatabaseAlias());
        table.setIsCreateTable(1);
        //table.setCode(table.getTableName());
        this.update(table);
        String categoryId="31063";
        String categoryName="默认分类";
        //2014、12、15 laowang 不同步表到宏天去
        //Map<String,String> idsMap= SyncTableUtil.createMouldAndTable(jdbcTemplate,template,table.getId(),table.getId(),table.getName(),table.getCode(),table.getDescription(),info.getDatabaseAlias(),fieldList,categoryId,categoryName);

    }

    /**
     * 手动建触发器
     */
    @Transactional(rollbackFor = Exception.class )
    public void createdTrigger(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizClusterTable table= this.getById(tableId);
        //BizClusterMould module= this.mouldManager.getById(table.getMouldId());
        BizClusterInfoMode info=infoModeManager.getById(table.getClusterId());
        BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
       /* BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dataSourcesRelation.getAlias());*/
        //创建触发器记录日志
        MySQLUtils.createTiger(template,table.getTableNameCh(),info.getCompanyName(),info.getSysName(),info.getSysCode(),table.getName(),table.getCode());
    }

    /**
     * 查询触发器SQl
     */
    public List<Map<String,String>> queryTriggerSql(String tableId) throws Exception{
        BizClusterTable table= this.getById(tableId);
        //BizClusterMould module= this.mouldManager.getById(table.getMouldId());
        BizClusterInfoMode info=infoModeManager.getById(table.getClusterId());
        String tableName=table.getTableNameCh();
        String companyName=info.getCompanyName();
        String sysName=info.getSysName();
        String sysCode=info.getSysCode();
        String name= table.getName();
        String code= table.getCode();

        String insertInsertSql=MySQLUtils.initTriggerSql( tableName, companyName, sysName, sysCode, name, code,"INSERT","1");
        String insertUpdateSql=MySQLUtils.initTriggerSql( tableName, companyName, sysName, sysCode, name, code,"UPDATE","2");
        String insertDeleteSql=MySQLUtils.initTriggerSql( tableName, companyName, sysName, sysCode, name, code,"DELETE","2");

        List<Map<String,String>> triggers=new ArrayList<>();

        Map<String,String> triggerInsertMap=new HashMap<>();
        triggerInsertMap.put("sql",insertInsertSql);
        triggerInsertMap.put("name",tableName+"_insert_tiger ");
        triggerInsertMap.put("type","INSERT");

        Map<String,String> triggerUpdateMap=new HashMap<>();
        triggerUpdateMap.put("sql",insertUpdateSql);
        triggerUpdateMap.put("name",tableName+"_update_tiger ");
        triggerUpdateMap.put("type","UPDATE");

        Map<String,String> triggerDelMap=new HashMap<>();
        triggerDelMap.put("sql",insertDeleteSql);
        triggerDelMap.put("name",tableName+"_delete_tiger ");
        triggerDelMap.put("type","DELETE");

        triggers.add(triggerInsertMap);
        triggers.add(triggerUpdateMap);
        triggers.add(triggerDelMap);
        return triggers;
    }

    private void addManageField(List<BizClusterTableField> fieldList){
        BizClusterTableField createBy = new BizClusterTableField();
        createBy.setFieldName("CREATE_BY_");
        createBy.setName("创建人");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("创建人");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsRequired("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");

        BizClusterTableField createOrgId = new BizClusterTableField();
        createOrgId.setFieldName("CREATE_ORG_ID_");
        createOrgId.setName("创建单位");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("创建单位");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsRequired("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");

        BizClusterTableField createTime = new BizClusterTableField();
        createTime.setFieldName("CREATE_TIME_");
        createTime.setName("创建时间");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("创建时间");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsRequired("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");

        BizClusterTableField id = new BizClusterTableField();
        id.setFieldName("ID_");
        id.setName("主键");
        id.setCode("ID_");
        id.setDesc("主键");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsRequired("0");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);

        Set<String> set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())){
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())){
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())){
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())){
            fieldList.add(id);
        }
    }

    /**
     * 查询表SQla
     */
    public String queryTableSql(String tableId) throws Exception{
        BizClusterTable table= this.getById(tableId);
        if(org.apache.commons.lang3.StringUtils.isNotBlank(table.getCreateTableSql())){
            return table.getCreateTableSql();
        }
        List<BizClusterTableField> fieldList = fieldManager.queryFieldByTableId(tableId);
//        addManageField(fieldList);
        // 建表语句
        StringBuffer sb = new StringBuffer();
        // 主键字段
        String pkColumn = null;
        // 建表开始
        sb.append("CREATE TABLE " + table.getTableNameEn() + " (\n");
        for (int i = 0; i < fieldList.size(); i++) {
            // 建字段
            BizClusterTableField cm = fieldList.get(i);
            Integer attrLength=cm.getAttrLength()==null ? 0 : cm.getAttrLength();
            Integer decimalLen=cm.getDecimalLen()==null ? 4 : cm.getDecimalLen();
            sb.append(cm.getFieldName()).append(" ");
            sb.append(FieldUtil.getColumnType(cm.getDataType(), attrLength, attrLength, decimalLen));
            sb.append("1".equals(cm.getIsRequired()) ? " NOT NULL " : " NULL");
            sb.append(" ");

            String defaultValue = cm.getDefaultValue();

            // 添加默认值。大文本除外，因为mysql不允许
            if (StringUtils.isNotEmpty(defaultValue) && !Column.COLUMN_TYPE_CLOB.equals(cm.getDataType())) {
                /*if (Column.COLUMN_TYPE_DATE.equals(cm.getDataType())) {
                    defaultValue  =formatTimeDefaultValue(cm, defaultValue);
                }*/
                if (Column.COLUMN_TYPE_NUMBER.equals(cm.getDataType()) || Column.COLUMN_TYPE_INT.equals(cm.getDataType())) {
                    sb.append(" default " + defaultValue);
                } else {
                    sb.append(" default '" + defaultValue + "' ");
                }
            }
            // 主键
            if ("1".equals(cm.getIsPk())) {
                if (pkColumn == null) {
                    pkColumn = cm.getFieldName();
                } else {
                    pkColumn += "," + cm.getFieldName();
                }
            }
            // 字段注释
            if (cm.getDesc() != null && cm.getDesc().length() > 0) {
                sb.append(" COMMENT '" + cm.getDesc() + "'");
            }
            if(i<fieldList.size()-1){
                sb.append(",\n");
            }
        }
        // 建主键
        /*if (pkColumn != null)
            sb.append(" ，PRIMARY KEY (" + pkColumn + ")");*/

        sb.append("\n)");

        // 表注释
        if (table.getDescription() != null && table.getDescription().length() > 0) {
            sb.append(" COMMENT='" + table.getDescription() + "'");
        }
        // 建表结束
        sb.append(";");
        System.out.println(sb);
        //jdbcTemplate.execute(sb.toString());
        return sb.toString();
    }

    public QueryResultData queryTableData (QueryParamVo queryParamVo) throws Exception{
        //Assert.hasText(queryParamVo.getTableId(),"表ID不能为空");
        if(StringUtil.isEmpty(queryParamVo.getTableId()) && StringUtil.isEmpty(queryParamVo.getTableName())){
            throw new ApplicationException("表ID或者表名不能为空");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties(queryParam,queryParamVo);
        BizClusterTable table= null;
        if(StringUtil.isNotEmpty(queryParam.getTableId())){
            table = this.getById(queryParam.getTableId());
        }else {
            QueryWrapper<BizClusterTable> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("TABLE_NAME_EN_", queryParamVo.getTableName());
            table = this.baseMapper.selectOne(queryWrapper);
        }

        if(table == null){
            return null;
        }
        //BizClusterMould module= this.mouldManager.getById(table.getMouldId());
        BizClusterInfoMode infoMode = this.infoModeManager.getById(table.getClusterId());
        queryParam.setTableName(table.getTableNameEn());
        List<BizClusterTableField> fieldList = fieldManager.queryFieldByTableId(table.getId());
        //只提取业务字段
        Map<String,String> field = new HashMap<>();//fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toMap(BizClusterTableField::getFieldName,p->p.getName()));
        for(BizClusterTableField item : fieldList){
            if("2".equals(item.getFieldType())){
                //field.put("F_"+item.getFieldName(),item.getName());
                field.put(item.getCode(),item.getName());
            }
        }
        field.put("ID_","主键");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());

        /*BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dataSourcesRelation.getAlias());*/
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType(infoMode.getDatabaseType());
        QueryResultData resultData= QueryDataTableFactory.getTableData(queryParam);
        return resultData;
    }

    /*public Map<String,Object> queryTableData (String tableId,Map<String,String> param,String order,Integer page,Integer pageSize) throws Exception{
        Map<String,Object> result=new HashMap<>();
        BizClusterTable table= this.getById(tableId);
        BizClusterMould module= this.mouldManager.getById(table.getMouldId());
        BizClusterInfoMode info=infoModeManager.getById(module.getClusterId());
        List<BizClusterField> fieldList = fieldManager.queryFieldByTableId(tableId);
        *//*BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }*//*
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(info.getDatabaseAlias());

        String tableName=table.getTableName();
        String querySql="select * from "+tableName+" where 1=1";
        String querySqlCount="select count(*) from "+tableName+" where 1=1";
        for(String key : param.keySet()){
            querySql=" and "+key+" = '"+param.get(key)+"'";
            querySqlCount=" and "+key+" = '"+param.get(key)+"'";
        }
        if(page>1) {
            result.put("total", template.queryForObject(querySqlCount, Integer.class));
        }
        if(StringUtil.isNotEmpty(order)){
            querySql+=" order by "+order;
        }else{
            querySql+=" order by f_create_time_";
        }
        if(page>1) {
            querySql += " limit " + ((page - 1) * pageSize) + "," + pageSize;
        }
        result.put("data",template.queryForList(querySql));
        result.put("field",fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toList()));
        return result;
    }*/

    public List<BizClusterTable> queryDeployed(){
        QueryWrapper<BizClusterTable> queryWrapper= new QueryWrapper<>();
        queryWrapper.eq("DEPLOYED_",1);
        return this.list(queryWrapper);
    }

    public List<BizClusterTable> queryTableByClusterId(String clusterId) throws Exception{
        QueryWrapper<BizClusterTable> queryWrapper= new QueryWrapper<>();
        queryWrapper.eq("CLUSTER_ID_",clusterId);
        return this.list(queryWrapper);
    }

    //根据表下载导入模板
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception {
        BizClusterTable dwTable = this.getById(tableId);
        List<BizClusterTableField> field=fieldManager.queryFieldByTableId(tableId);
        if(field.size()==0){
            throw new ApplicationException("资源表未设置字段。");
        }
        Map<String,String> exportMap = new LinkedHashMap<>();
        for(BizClusterTableField field1 : field){
            //只显示管理字段
            if("2".equalsIgnoreCase(field1.getFieldType())){
                exportMap.put(field1.getName(), field1.getDesc());
            }
        }
        // 拼装exprotMaps
        HSSFWorkbook book = ExcelUtil.exportExcel(dwTable.getName(), 12, exportMap, new ArrayList<>(), 0);
        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder(rootRealPath, true);
        String path = rootRealPath+File.separator+System.currentTimeMillis()+".xls";
        book.write(new File(path));
        dwTable.setDatafileDownUrl(path);
        ExcelUtil.downloadExcel(book, dwTable.getName() + "_导入模板", response);
        //book.write(new File("C:\\123.xls"));

    }

    //根据表和EXCEL导入数据到表
    @Override
    @Transactional(rollbackFor = Exception.class )
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizClusterTable table = this.getById(tableId);
        List<BizClusterTableField> fieldLists=fieldManager.queryFieldByTableId(tableId);
        Map<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizClusterTableField field : fieldLists) {//这里同注释的会被覆盖，所以要导入导出的不要出现相同的列注释
            //管理字段
            if("2".equalsIgnoreCase(field.getFieldType())) {
                nameFieldMap.put(field.getDesc(), field.getFieldName());
            }
        }
        List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
        BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
       /* BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dataSourcesRelation.getAlias());*/
        IUser user= ContextUtil.getCurrentUser();
        IGroup org=ContextUtil.getCurrentGroup();
        String uId=user.getUserId();
        String orgId=org.getGroupId();
        for (Map<String, String> row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");

            List<String> fields = new ArrayList<String>();
            List<String> values = new ArrayList<String>();
            fields.add(BizClusterTableField.PK_NAME);
            String bizId=UniqueIdUtil.getSuid();
            values.add(bizId);
            for (Map.Entry<String, String> map : row.entrySet()) {
                //excel单元格有值才去拼接sql
                if (BeanUtils.isNotEmpty(map.getValue())) {
                    String key = map.getKey();
                    String field = this.getFieldName(key, fieldLists, nameFieldMap.get(key));
                    if("ID_".equalsIgnoreCase(field) || "F_form_data_rev_".equalsIgnoreCase(field)){
                        continue;
                    }
                    //fields.add("F_"+field);
                    fields.add(field);
                    String dataType = this.getDataType(key, fieldLists, nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add(map.getValue());
                    } else {
                        values.add("'" + map.getValue() + "'");
                    }
                }

            }
            //加入额外的两个字段
            //fields.add("F_form_data_rev_");
            //values.add("0");

            sql.append(table.getTableNameEn());
            sql.append("(" + String.join(",", fields) + ",CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_)");
            sql.append(" values ");
            sql.append("(" + String.join(",", values) + ",'"+uId+"','"+orgId+"',now())");//todo 获取登陸人信息的方法
            template.execute(sql.toString());

            //记录导入日志
            BizClusterTempDataLog log=new BizClusterTempDataLog();
            log.setCompanyName(infoMode.getCompanyName());
            log.setSysName(infoMode.getSysName());
            log.setSysCode(infoMode.getSysCode());
            log.setName(table.getName());
            log.setCode(table.getCode());
            log.setDataType(1);
            log.setCreateTime(LocalDateTime.now());
            log.setTableName(table.getTableNameEn());
            log.setSrcId(bizId);
            tempDataLogManager.save(log);
        }
    }

    private String getFieldName(String key, List<BizClusterTableField> columnList, String fieldName) {
        for (BizClusterTableField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getFieldName();
            }
        }
        return "";
    }

    private String getDataType(String key, List<BizClusterTableField> columnList, String fieldName) {
        for (BizClusterTableField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getDataType();
            }
        }
        return "";
    }

    @Override
    public IPage<BizClusterTable> getClusterTableQueryList(QueryFilter<BizClusterTable> queryFilter) throws Exception {
        return baseMapper.getClusterTableQueryList(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
    }

    @Override
    @Transactional
    public void deployHaveTable(String tableId,String createTrigger) throws Exception {
        BizClusterTable table = this.get(tableId);
        if(1==table.getDeployed()){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        //table.setCreateTableSql(tableSql);
        this.update(table);

        //创建触发器
        if("1".equals(createTrigger)){
            BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
            createTrigger(template,table);
        }
    }

    @Override
    @Transactional
    public void deployDotHaveTable(String tableId,String tableSql,String createTrigger) throws Exception {
        BizClusterTable table = this.get(tableId);
        List<BizClusterTableField> tableFields = fieldManager.queryFieldByTableId(tableId);
        if(1==table.getDeployed()){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        if(tableFields.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        table.setCreateTableSql(tableSql);
        BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        template.execute(table.getCreateTableSql());
        this.update(table);

        //创建触发器
        if("1".equals(createTrigger)){
            createTrigger(template,table);
        }
    }

    public void  createTrigger(JdbcTemplate template,BizClusterTable table){
        String tableId = table.getId();
        BizClusterInfoMode info=infoModeManager.getById(table.getClusterId());
        Map<String,String> triggerMap=MySQLUtils.createTiger(template,table.getTableNameEn(),info.getCompanyName(),info.getSysName(),info.getSysCode(),table.getName(),table.getCode());

        BizClusterTableTrigger triggerInsert=new BizClusterTableTrigger();
        triggerInsert.setIsCreateTable(1);
        triggerInsert.setMouldCode(table.getCode());
        triggerInsert.setMouldName(table.getTableNameCh());
        triggerInsert.setTableId(tableId);
        triggerInsert.setTriggerSql(triggerMap.get("insert"));
        triggerInsert.setTriggerType("1");
        triggerInsert.setName(table.getTableNameCh()+"添加数据触发器");
        triggerInsert.setCode(table.getTableNameEn()+"_insert_tiger");
        triggerManager.create(triggerInsert);

        BizClusterTableTrigger triggerUpdate=new BizClusterTableTrigger();
        triggerUpdate.setIsCreateTable(1);
        triggerUpdate.setMouldCode(table.getCode());
        triggerUpdate.setMouldName(table.getTableNameCh());
        triggerUpdate.setTableId(tableId);
        triggerUpdate.setTriggerSql(triggerMap.get("update"));
        triggerUpdate.setTriggerType("2");
        triggerUpdate.setName(table.getTableNameCh()+"修改数据触发器");
        triggerUpdate.setCode(table.getTableNameEn()+"_update_tiger");
        triggerManager.create(triggerUpdate);

        BizClusterTableTrigger triggerDelete=new BizClusterTableTrigger();
        triggerDelete.setIsCreateTable(1);
        triggerDelete.setMouldCode(table.getCode());
        triggerDelete.setMouldName(table.getTableNameCh());
        triggerDelete.setTableId(tableId);
        triggerDelete.setTriggerSql(triggerMap.get("delete"));
        triggerDelete.setTriggerType("3");
        triggerDelete.setName(table.getTableNameCh()+"添加数据触发器");
        triggerDelete.setCode(table.getTableNameEn()+"_delete_tiger");
        triggerManager.create(triggerDelete);
    }

    @Transactional
    public void  copyTable(CopyTableVo vo)throws Exception{
        String sourceTableId=vo.getSourceTableId();
        List<BizClusterTableField> fields = fieldManager.queryFieldByTableId(sourceTableId);
        BizClusterTable table=vo.parse(vo);
        table.setId(null);
        this.save(table);
        for(BizClusterTableField item : fields){
            item.setTableId(table.getId());
            item.setFieldName(item.getCode());
            item.setCreateBy(null);
            item.setCreateOrgId(null);
            item.setCreateTime(null);
            item.setUpdateBy(null);
            item.setUpdateOrgId(null);
            item.setUpdateTime(null);
            item.setIsCreate("1");
        }
        if(fields.size()>0){
            this.fieldManager.saveOrUpdateBatch(fields);
        }
    }

    @Override
    public boolean checkTableExists(String clusterId,String tableNameEn) throws Exception{
        BizClusterInfo info=infoManager.getById(clusterId);
        tableNameEn = info.getSysTableCode()+"_"+tableNameEn;
        //查询表库是否存在
        if(checkTable(tableNameEn)){
            return true;
        }
        //查询数据库是否存在
        BizClusterInfoMode infoMode=infoModeManager.getById(clusterId);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Transactional(rollbackFor = Exception.class )
    public void removeTable(String tableId) throws Exception {
        BizClusterTable table=this.getById(tableId);
        BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
        boolean exists = checkPhysicsTableExists(table.getClusterId(),table.getTableNameEn());
        if (exists){
            //如果表已经发布，删除实体表
            if("1".equals(table.getDeployed())){
                String dropSql="drop table "+table.getTableNameEn();
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
                template.execute(dropSql);
            }
        }
        QueryWrapper<BizClusterTableField> queryWrapper=new QueryWrapper();
        queryWrapper.eq("TABLE_ID_",tableId);
        this.removeById(tableId);
        this.fieldManager.getBaseMapper().delete(queryWrapper);
    }

    @Override
    public boolean checkPhysicsTableExists(String clusterId, String tableNameEn) throws Exception {
        //查询数据库是否存在
        BizClusterInfoMode infoMode=infoModeManager.getById(clusterId);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }
}