package com.artfess.dataShare.algorithm.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 算法推理管理----指标值结果关联配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@ApiModel(value="BizAlgorithmResultItem对象", description="算法推理管理----指标值结果关联配置表")
public class BizAlgorithmResultItem extends BaseModel<BizAlgorithmResultItem> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "特征指标类型（1：结果指标 2：问题指标 3：属性指标）")
    @TableField("INDEX_TYPE_")
    private String indexType;

    @ApiModelProperty(value = "特征指标ID")
    @TableField("INDEX_ID_")
    private String indexId;

    @ApiModelProperty(value = "特征指标编码")
    @TableField("INDEX_CODE_")
    private String indexCode;

    @ApiModelProperty(value = "特征指标名称")
    @TableField("INDEX_NAME_")
    private String indexName;

    @ApiModelProperty(value = "结果指标值_KEY（枚举则参考KEY）")
    @TableField("REASON_KEY_")
    private String reasonKey;

    @ApiModelProperty(value = "结果指标值_VALUE（枚举则参考VALUE）")
    @TableField("REASON_VALUE_")
    private String reasonValue;

    @ApiModelProperty(value = "结果特征类型（字典：优点/缺点/痛点/盲点/适合工作..）")
    @TableField("REASON_TYPE_")
    private String reasonType;

    @ApiModelProperty(value = "结果特征描述")
    @TableField("REASON_CONTENT_")
    private String reasonContent;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIndexType() {
        return indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getIndexId() {
        return indexId;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public String getIndexName() {
        return indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getReasonKey() {
        return reasonKey;
    }

    public void setReasonKey(String reasonKey) {
        this.reasonKey = reasonKey;
    }

    public String getReasonValue() {
        return reasonValue;
    }

    public void setReasonValue(String reasonValue) {
        this.reasonValue = reasonValue;
    }

    public String getReasonType() {
        return reasonType;
    }

    public void setReasonType(String reasonType) {
        this.reasonType = reasonType;
    }

    public String getReasonContent() {
        return reasonContent;
    }

    public void setReasonContent(String reasonContent) {
        this.reasonContent = reasonContent;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAlgorithmResultItem{" +
            "id=" + id +
            ", indexType=" + indexType +
            ", indexId=" + indexId +
            ", indexCode=" + indexCode +
            ", indexName=" + indexName +
            ", reasonKey=" + reasonKey +
            ", reasonValue=" + reasonValue +
            ", reasonType=" + reasonType +
            ", reasonContent=" + reasonContent +
            ", sn=" + sn +
        "}";
    }
}
