/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.controller.BaseController;
import com.artfess.portal.params.RedisInfo;
import com.artfess.portal.persistence.manager.RedisService;
import com.artfess.portal.util.jvm.ApplicationMonitorMessage;
import com.artfess.portal.util.jvm.ApplicationMonitorTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.filechooser.FileSystemView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/actuator/v1"})
@Api(tags={"\u7cfb\u7edf\u914d\u7f6e-redis\u76d1\u63a7\u3001jvm\u76d1\u63a7"})
@ApiGroup(group={"group_system"})
public class ActuatorRedisController
extends BaseController {
    @Autowired
    private RedisService redisService;
    @Autowired
    private ApplicationMonitorTask jvmTask;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u5b57\u5178\u7f13\u5b58");

    @GetMapping(value={"/redis/info"})
    @ApiOperation(value="Redis\u8be6\u7ec6\u4fe1\u606f")
    public List<RedisInfo> getRedisInfo() throws Exception {
        List<RedisInfo> infoList = this.redisService.getRedisInfo();
        return infoList;
    }

    @GetMapping(value={"/redis/keysSize"})
    @ApiOperation(value="Redis\u6570\u636e\u5e93\u4e2a\u6570")
    public Map<String, Object> getKeysSize() throws Exception {
        Map<String, Object> retuslt = this.redisService.getKeysSize();
        return retuslt;
    }

    @GetMapping(value={"/redis/memoryInfo"})
    @ApiOperation(value="\u83b7\u53d6 redis \u5185\u5b58\u4fe1\u606f")
    public Map<String, Object> getMemoryInfo() throws Exception {
        return this.redisService.getMemoryInfo();
    }

    @GetMapping(value={"/redis/queryDiskInfo"})
    @ApiOperation(value="\u83b7\u53d6\u78c1\u76d8\u4fe1\u606f")
    public List<Map<String, Object>> queryDiskInfo(HttpServletRequest request, HttpServletResponse response) {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File[] fs = File.listRoots();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i].getTotalSpace() == 0L) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", fsv.getSystemDisplayName(fs[i]));
            map.put("max", fs[i].getTotalSpace());
            map.put("rest", fs[i].getFreeSpace());
            map.put("restPPT", (fs[i].getTotalSpace() - fs[i].getFreeSpace()) * 100L / fs[i].getTotalSpace());
            list.add(map);
        }
        return list;
    }

    @GetMapping(value={"/jvm/jvmMessage"})
    @ApiOperation(value="\u83b7\u53d6 jvm \u5185\u5b58\u4fe1\u606f")
    public ApplicationMonitorMessage jvmMessage() throws Exception {
        return this.jvmTask.doRun();
    }

    @PostMapping(value={"/redis/getAllCache"})
    @ApiOperation(value="\u67e5\u627e\u6240\u6709\u7684\u7f13\u5b58\u4fe1\u606f/\u6839\u636ekey\u67e5\u627eredis", httpMethod="POST", notes="\u67e5\u627e\u6240\u6709\u7684\u7f13\u5b58\u4fe1\u606f/\u6839\u636ekey\u67e5\u627eredis")
    public Map<String, Object> getAllCache(@ApiParam(value="\u7f13\u5b58Key\u503c") @RequestParam(required=false) String cacheKey) {
        return this.redisService.getAllCache(cacheKey);
    }

    @PostMapping(value={"/redis/deleteCache"})
    @ApiOperation(value="\u6839\u636ekey\u5220\u9664\u7f13\u5b58", httpMethod="POST", notes="\u6839\u636ekey\u5220\u9664\u7f13\u5b58")
    public String deleteCache(String ... cacheKey) {
        return this.redisService.deleteCache(cacheKey);
    }
}

